//   ==================================================================
//   >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
//   ------------------------------------------------------------------
//   Copyright (c) 2006-2011 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED 
//   ------------------------------------------------------------------
//
//   IMPORTANT: THIS FILE IS AUTO-GENERATED BY THE LATTICEMICO SYSTEM.
//
//   Permission:
//
//      Lattice Semiconductor grants permission to use this code
//      pursuant to the terms of the Lattice Semiconductor Corporation
//      Open Source License Agreement.  
//
//   Disclaimer:
//
//      Lattice Semiconductor provides no warranty regarding the use or
//      functionality of this code. It is the user's responsibility to
//      verify the users design for consistency and functionality through
//      the use of formal verification methods.
//
//   --------------------------------------------------------------------
//
//                  Lattice Semiconductor Corporation
//                  5555 NE Moore Court
//                  Hillsboro, OR 97214
//                  U.S.A
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                         503-286-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
//   --------------------------------------------------------------------
//                         FILE DETAILS
// Project          : LM32 DMA Component
// File             : wb_dma_ctrl.v
// Title            : DMA controller top file
// Dependencies     : None
//                  :
// Version          : 7.0
//                  : Initial Release
//                  :
// Version          : 7.0SP2, 3.0
//                  : 1. Read and Write channel of DMA controller are working in 
//                  :    parallel, due to that now as soon as FIFO is not empty 
//                  :    write channel of the DMA controller start writing data 
//                  :    to the slave.
//                  : 2. Burst Size supported by DMA controller is increased to 
//                  :    support bigger burst (from current value of 4 and 8 to 
//                  :    16 and 32). Now 4 different type of burst sizes are 
//                  :    supported by the DMA controller 4, 8, 16 and 32. For 
//                  :    this Burst Size field of the control register is 
//                  :    increased to 2 bits.
//                  : 3. Glitch is removed on the S_ACK_O signal. 
//                  :
// Version          : 3.1
//                  : Make DMA Engine compliant to Rule 3.100 of Wishbone Spec
//                  : which defines alignement of bytes in sub-word transfers.
//                  :
// Version          : 3.2
//                  : 1. Support for 8/32-bit WISHBONE Data Bus. The Control and
//                  :    Read/Write Ports can be independently configured.
//                  : 2. Support for "retry" on receipt of a WISHBONE RTY. This
//                  :    retry results in the current burst or classic cycle
//                  :    being issued again after a retry timeout.
//                  : 3. Support for "error" on receipt of a WISHBONE ERR. This
//                  :    results in the current dma transfer being terminated
//                  :    and the error is updated within the STATUS CSR.
//                  : 4. Support for burst size of 64.
//                  :
// Version          : 3.3
//                  : Support for MachXO2 added. The MachXO2 only has a FIFO 
//                  : with separate read/write clocks.
// =============================================================================

`ifndef MASTER_CTRL_FILE
 `define MASTER_CTRL_FILE
 `include "system_conf.v"
module MASTER_CTRL 
  #(parameter MA_WB_DAT_WIDTH = 32,
    parameter MA_WB_ADR_WIDTH = 32,
    parameter MB_WB_DAT_WIDTH = 32,
    parameter MB_WB_ADR_WIDTH = 32,
    parameter S_WB_DAT_WIDTH  = 32,
    parameter FIFO_IMPLEMENTATION = "EBR")
   (
    // System clock and reset
    input CLK_I,
    input RST_I,
    // Master read port
    output reg [MA_WB_ADR_WIDTH-1:0] MA_ADR_O,
    output reg [MA_WB_DAT_WIDTH/8-1:0] MA_SEL_O,
    output reg [MA_WB_DAT_WIDTH-1:0] MA_DAT_O,
    output reg MA_WE_O,
    output reg MA_STB_O,
    output reg MA_CYC_O,
    output reg [2:0] MA_CTI_O,
    output reg MA_LOCK_O,
    input [MA_WB_DAT_WIDTH-1:0] MA_DAT_I,
    input MA_ACK_I,
    input MA_ERR_I,
    input MA_RTY_I,
    // Master write port
    output reg [MB_WB_ADR_WIDTH-1:0] MB_ADR_O,
    output reg [MB_WB_DAT_WIDTH/8-1:0] MB_SEL_O,
    output reg [MB_WB_DAT_WIDTH-1:0] MB_DAT_O,
    output reg MB_WE_O,
    output reg MB_STB_O,
    output reg MB_CYC_O,
    output reg [2:0] MB_CTI_O,
    output reg MB_LOCK_O,
    input MB_ACK_I,
    input MB_ERR_I,
    input MB_RTY_I,
    // Register interface
    input reg_start,
    output reg reg_busy,
    output reg reg_status,
    output reg reg_interrupt,
    input reg_bt3, reg_bt2, reg_bt1, reg_bt0,
    input reg_s_con, reg_d_con,
    input reg_incw, reg_inchw,
    input [7:0] reg_rdelay,
    input [31:0] reg_00_data,
    input [31:0] reg_04_data,
    input [31:0] reg_08_data
    );
   
   parameter lat_family           = `LATTICE_FAMILY;   
   parameter UDLY                 = 1;
   
   wire [MB_WB_DAT_WIDTH-1:0] fifo_dout;
   wire 		      fifo_empty, fifo_aempty;
   reg [MA_WB_DAT_WIDTH-1:0]  fifo_din;
   
   reg [31:0] 		      xfer_length, xfer_length_nxt;
   reg [5:0] 		      rburst_count, rburst_count_nxt;
   reg [5:0] 		      wburst_count, wburst_count_nxt;
   reg [5:0] 		      save_wburst_count, save_wburst_count_nxt;
   reg [31:0] 		      raddr_checkpoint, raddr_checkpoint_nxt, waddr_checkpoint, waddr_checkpoint_nxt;
   reg [7:0] 		      retry_delay, retry_delay_nxt;
   reg 			      MA_CYC_O_nxt, MA_STB_O_nxt, MA_CYC_O_d;
   reg [2:0] 		      MA_CTI_O_nxt;
   reg [MA_WB_ADR_WIDTH-1:0]  MA_ADR_O_nxt;
   reg [MA_WB_DAT_WIDTH/8-1:0] MA_SEL_O_nxt;
   reg 			      MB_CYC_O_nxt, MB_STB_O_nxt, MB_CYC_O_d;
   reg [2:0] 		      MB_CTI_O_nxt;   
   reg [MB_WB_ADR_WIDTH-1:0]  MB_ADR_O_nxt;
   reg [MB_WB_DAT_WIDTH/8-1:0] MB_SEL_O_nxt;
   reg 			      reg_status_nxt;
   reg 			      burst_start, xfer_done;
   wire [2:0] 		      iCount;
   wire [5:0] 		      bCount;
   wire [8:0] 		      biCount;
   
   /*----------------------------------------------------------------------
    
    READ State Machine
    
    ----------------------------------------------------------------------*/
   reg [2:0] rstate, rstate_nxt;
   parameter RD_IDLE         = 3'b000;
   parameter RD_SINGLEA      = 3'b001;
   parameter RD_SINGLEB      = 3'b010;
   parameter RD_SINGLE_RETRY = 3'b011;
   parameter RD_BURST        = 3'b100;
   
   always @(/*AUTOSENSE*/MA_ACK_I or MA_ERR_I or MA_RTY_I or MB_ERR_I
	    or MB_RTY_I or burst_start or rburst_count or reg_bt3
	    or reg_start or retry_delay or rstate or xfer_done)
     casez (rstate)
       RD_IDLE:
	 if (reg_start && (reg_bt3 == 1'b0))
	   rstate_nxt = RD_SINGLEA;
	 else if (burst_start && reg_bt3)
	   rstate_nxt = RD_BURST;
	 else
	   rstate_nxt = rstate;
              
       RD_SINGLEA:
	 if (MA_ACK_I)
	   rstate_nxt = RD_SINGLEB;
	 else if (MA_ERR_I)
	   rstate_nxt = RD_IDLE;
	 else if (MA_RTY_I)
	   rstate_nxt = RD_SINGLE_RETRY;
	 else
	   rstate_nxt = rstate;
       
       RD_SINGLEB:
	 if (burst_start)
	   rstate_nxt = RD_SINGLEA;
	 else if (MB_ERR_I || xfer_done)
	   rstate_nxt = RD_IDLE;
	 else if (MB_RTY_I)
	   rstate_nxt = RD_SINGLE_RETRY;
	 else
	   rstate_nxt = rstate;
       
       RD_BURST:
	 if (MB_ERR_I || MB_RTY_I || MA_ERR_I || MB_RTY_I || (MA_ACK_I && (rburst_count == 0)))
	   rstate_nxt = RD_IDLE;
	 else
	   rstate_nxt = rstate;
       	 
       RD_SINGLE_RETRY:
	 if (retry_delay == 8'h0)
	   rstate_nxt = RD_SINGLEA;
	 else
	   rstate_nxt = rstate;
       
       default:
	 rstate_nxt = RD_IDLE;
     endcase
   
   /*----------------------------------------------------------------------
    
    WRITE State Machine
    
    ----------------------------------------------------------------------*/
   reg [3:0] wstate, wstate_nxt;
   parameter WR_IDLE       = 4'b0000;
   parameter WR_SINGLEA    = 4'b0001;
   parameter WR_SINGLEB    = 4'b0010;
   parameter WR_FIFO_CHECK = 4'b0011;
   parameter WR_SHORT      = 4'b0100;
   parameter WR_BURST      = 4'b0101;
   parameter WR_SBURST     = 4'b0110;
   parameter WR_SETUPA     = 4'b0111;
   parameter WR_SETUPB     = 4'b1000;
   parameter WR_ERROR      = 4'b1001;
   parameter WR_RETRY      = 4'b1010;
   
   always @(/*AUTOSENSE*/MA_ERR_I or MA_RTY_I or MB_ACK_I or MB_ERR_I
	    or MB_RTY_I or fifo_aempty or fifo_empty or iCount
	    or reg_bt3 or reg_start or retry_delay or wburst_count
	    or wstate or xfer_length)
     casez (wstate)
       WR_IDLE:
	 if (reg_start)
	   wstate_nxt = reg_bt3 ? WR_SETUPA : WR_SINGLEA;
	 else
	   wstate_nxt = wstate;
       
       WR_SINGLEA:
	 if (MA_ERR_I)
	   wstate_nxt = WR_IDLE;
	 else if (fifo_empty == 1'b0)
	   wstate_nxt = WR_SINGLEB;
	 else
	   wstate_nxt = wstate;
       
       WR_SINGLEB:
	 if (MB_ACK_I)
	   wstate_nxt = (xfer_length == iCount) ? WR_IDLE : WR_SINGLEA;
	 else if (MB_ERR_I)
	   wstate_nxt = WR_IDLE;
	 else if (MB_RTY_I)
	   wstate_nxt = WR_SINGLEA;
	 else
	   wstate_nxt = wstate;
       
       WR_FIFO_CHECK:
	 if (MA_ERR_I)
	   wstate_nxt = WR_ERROR;
	 else if (MA_RTY_I)
	   wstate_nxt = WR_RETRY;
	 else
	   if ((fifo_empty == 1'b0) && (wburst_count == 6'h0))
	     wstate_nxt = WR_SHORT;
	   else if ((fifo_aempty == 1'b0) && (wburst_count >= 6'h1))
	     wstate_nxt = WR_BURST;
	   else
	     wstate_nxt = wstate;
       
       WR_SHORT:
	 if (MA_ERR_I)
	   wstate_nxt = WR_ERROR;
	 else if (MA_RTY_I)
	   wstate_nxt = WR_RETRY;
	 else
	   if (MB_ACK_I)
	     wstate_nxt = WR_FIFO_CHECK;
	   else if (MB_ERR_I)
	     wstate_nxt = WR_ERROR;
	   else if (MB_RTY_I)
	     wstate_nxt = WR_RETRY;
	   else
	     wstate_nxt = wstate;
       
       WR_BURST:
	 if (MA_ERR_I)
	   wstate_nxt = WR_ERROR;
	 else if (MA_RTY_I)
	   wstate_nxt = WR_RETRY;
	 else
	   if (MB_ACK_I)
	     if (fifo_aempty && (wburst_count >= 6'h2))
	       wstate_nxt = WR_SBURST;
	     else if (wburst_count == 6'h0)
	       wstate_nxt = WR_SETUPA;
	     else
	       wstate_nxt = wstate;
	   else if (MB_ERR_I)
	     wstate_nxt = WR_ERROR;
	   else if (MB_RTY_I)
	     wstate_nxt = WR_RETRY;
	   else
	     wstate_nxt = wstate;
       
       WR_SBURST:
	 if (MA_ERR_I)
	   wstate_nxt = WR_ERROR;
	 else if (MA_RTY_I)
	   wstate_nxt = WR_RETRY;
	 else
	   if (MB_ACK_I)
	     wstate_nxt = WR_FIFO_CHECK;
	   else if (MB_RTY_I)
	     wstate_nxt = WR_RETRY;
	   else
	     wstate_nxt = wstate;
       
       WR_SETUPA:
	 wstate_nxt = WR_SETUPB;
       
       WR_SETUPB:
	 wstate_nxt = (wburst_count == 6'h0) ? WR_IDLE : WR_FIFO_CHECK;
       
       WR_ERROR:
	 wstate_nxt = fifo_empty ? WR_IDLE : wstate;
       
       WR_RETRY:
	 if (fifo_empty && (retry_delay == 8'h0))
	   wstate_nxt = WR_FIFO_CHECK;
	 else
	   wstate_nxt = wstate;
       
       default:
	 wstate_nxt = WR_IDLE;
     endcase
   
   /*----------------------------------------------------------------------
    Status Signals
    ----------------------------------------------------------------------*/
   always @(/*AUTOSENSE*/MA_ERR_I or MB_ERR_I or reg_status or wstate
	    or wstate_nxt)
     begin
	// Raise and hold busy signal until current DMA transfer is complete
	reg_busy = (wstate_nxt != WR_IDLE);
		
	// Raise and hold error signal until a new DMA transfer is initiated.
	// Error signal is raised when the WISHBONE cycle results in _ERR_I
	if ((wstate == WR_IDLE) && (wstate_nxt != WR_IDLE))
	  reg_status_nxt = 1'b0;
	else if (MA_ERR_I || MB_ERR_I)
	  reg_status_nxt = 1'b1;
	else
	  reg_status_nxt = reg_status;
		
	// Raise interrupt on completion of DMA transfer
	reg_interrupt = (wstate != WR_IDLE) & (wstate_nxt == WR_IDLE);
     end
   
   /*----------------------------------------------------------------------
    WISHBONE Read Port
    ----------------------------------------------------------------------*/
   always @(/*AUTOSENSE*/MA_ACK_I or MA_ADR_O or MA_CTI_O or MA_CYC_O
	    or MA_CYC_O_d or MA_ERR_I or MA_RTY_I or MA_STB_O
	    or MB_ERR_I or MB_RTY_I or burst_start or iCount
	    or raddr_checkpoint or rburst_count or reg_00_data
	    or reg_bt3 or reg_s_con or reg_start or rstate
	    or rstate_nxt)
     begin
	// MA_CYC_O and MA_STB_O
	
	// handle all conditions that cause MA_CYC_O to go 0
	if (((rstate == RD_SINGLEA) 
	     && (MA_ACK_I || MA_ERR_I || MA_RTY_I))
	    || ((rstate == RD_BURST)
		&& (MB_ERR_I || MB_RTY_I || (MA_ACK_I && (rburst_count == 6'h0)))))
	  begin
	     MA_CYC_O_nxt = 1'b0;
	     MA_STB_O_nxt = 1'b0;
	  end
	// handle all conditions that cause MA_CYC_O to go 1
	else if (((rstate_nxt == RD_SINGLEA) 
		  && ((rstate == RD_IDLE) || (rstate == RD_SINGLEB) || (rstate == RD_SINGLE_RETRY)))
		 || ((rstate == RD_BURST) && (MA_CYC_O_d == 1'b0)))
	  begin
	     MA_CYC_O_nxt = 1'b1;
	     MA_STB_O_nxt = 1'b1;
	  end
	// default: maintain state
	else
	  begin
	     MA_CYC_O_nxt = MA_CYC_O;
	     MA_STB_O_nxt = MA_STB_O;
	  end
	
	
	// MA_ADR_O
	
	// set up first address of the dma transfer
	if (reg_start)
	  MA_ADR_O_nxt = reg_00_data;
	else if (reg_s_con == 1'b0)
	  begin
	     // roll back to first address in a burst transfer on a retry
	     if (/*(rstate == RD_BURST) && */MB_RTY_I)
	       MA_ADR_O_nxt = raddr_checkpoint;
	     // increment for every regular transfer
	     else if ((MB_RTY_I == 1'b0)
		      && (((rstate == RD_SINGLEB) && burst_start)
			  || ((rstate == RD_BURST) && MA_ACK_I)))
	       MA_ADR_O_nxt = MA_ADR_O + iCount;
	     else
	       MA_ADR_O_nxt = MA_ADR_O;
	  end
	else
	  MA_ADR_O_nxt = MA_ADR_O;
	
	
	// MA_CTI_O
	
	if (reg_start || burst_start)
	  MA_CTI_O_nxt = reg_bt3 ? (reg_s_con ? 3'b001 : 3'b010) : 3'b000;
	else if ((rstate == RD_BURST) && (rburst_count == 6'h1) && MA_ACK_I)
	  MA_CTI_O_nxt = 3'b111;
	else
	  MA_CTI_O_nxt = MA_CTI_O;
	
	
	// Other signals
	MA_WE_O = 1'b0;
	MA_DAT_O = 0;
	MA_LOCK_O = 1'b0;
     end
   
   generate
      if (MA_WB_DAT_WIDTH == 8) begin
	 
	 always @(*)
	   MA_SEL_O_nxt = 1'b1;
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/MA_ADR_O_nxt or iCount)
	   begin
	      if (iCount == 1)
		casez (MA_ADR_O_nxt[1:0])
		  2'b00: MA_SEL_O_nxt = 4'b1000;
		  2'b01: MA_SEL_O_nxt = 4'b0100;
		  2'b10: MA_SEL_O_nxt = 4'b0010;
		  2'b11: MA_SEL_O_nxt = 4'b0001;
		  default:
		    MA_SEL_O_nxt = 4'b1111;
		endcase
	      else if (iCount == 2)
		MA_SEL_O_nxt = MA_ADR_O_nxt[1] ? 4'b0011 : 4'b1100;
	      else
		MA_SEL_O_nxt = 4'b1111;
	   end
	 
      end
   endgenerate
   
   
   /*----------------------------------------------------------------------
    WISHBONE Write Port
    ----------------------------------------------------------------------*/
   always @(/*AUTOSENSE*/MA_ERR_I or MA_RTY_I or MB_ACK_I or MB_ADR_O
	    or MB_CTI_O or MB_CYC_O or MB_ERR_I or MB_RTY_I
	    or MB_STB_O or fifo_aempty or fifo_dout or fifo_empty
	    or iCount or reg_04_data or reg_d_con or reg_s_con
	    or reg_start or waddr_checkpoint or wburst_count or wstate
	    or wstate_nxt)
     begin
	// MB_CYC_O and MB_STB_O
	
	// handle all conditions that cause MB_CYC_O to go 0
	if (((wstate == WR_SINGLEB) 
	     && (MB_ACK_I || MB_ERR_I || MB_RTY_I))
	    || ((MA_ERR_I || MA_RTY_I)
		&& ((wstate == WR_SHORT) || (wstate == WR_FIFO_CHECK) || (wstate == WR_BURST) || (wstate == WR_SBURST)))
	    || ((wstate == WR_BURST)
		&& ((MB_ACK_I && (wburst_count == 6'h0)) || MB_ERR_I || MB_RTY_I))
	    || ((wstate == WR_SBURST)
		&& (MB_ACK_I || MB_ERR_I || MB_RTY_I)))
	  begin
	     MB_CYC_O_nxt = 1'b0;
	     MB_STB_O_nxt = 1'b0;
	  end
	// handle all conditions that cause MB_CYC_O to go 1
	else if (((wstate == WR_SINGLEA) && (fifo_empty == 1'b0))
		 || ((wstate == WR_FIFO_CHECK)
		     && (((fifo_empty == 1'b0) && (wburst_count == 6'h0))
			 || ((fifo_aempty == 1'b0) && (wburst_count >= 6'h1)))))
	  begin
	     MB_CYC_O_nxt = 1'b1;
	     MB_STB_O_nxt = 1'b1;
	  end
	// default: maintain state
	else
	  begin
	     MB_CYC_O_nxt = MB_CYC_O;
	     MB_STB_O_nxt = MB_STB_O;
	  end
	
	
	// MB_ADR_O
	
	// set up first address of the dma transfer
	if (reg_start)
	  MB_ADR_O_nxt = reg_04_data;
	else if (reg_d_con == 1'b0)
	  begin
	     // roll back to first address in a burst transfer on a retry
	     if (wstate == WR_RETRY)
	       MB_ADR_O_nxt = waddr_checkpoint;
	     // increment for every regular transfer
	     else if (((wstate == WR_SINGLEB) && MB_ACK_I)
		      || (MB_ACK_I && (MA_RTY_I == 1'b0) && (MA_ERR_I == 1'b0)
			  && ((wstate == WR_SHORT) || (wstate == WR_BURST) || (wstate == WR_SBURST))))
	       MB_ADR_O_nxt = MB_ADR_O + iCount;
	     else
	       MB_ADR_O_nxt = MB_ADR_O;
	  end
	else
	  MB_ADR_O_nxt = MB_ADR_O;
	
	
	// MB_CTI_O
	
	// set up classic wishbone cycle
	if ((wstate == WR_SINGLEA)
	    || ((wstate == WR_FIFO_CHECK) && (wstate_nxt == WR_SHORT)))
	  MB_CTI_O_nxt = 3'b000;
	// set up termination of a wishbone burst cycle
	else if ((wstate == WR_BURST) 
		 && ((MB_ACK_I && (wburst_count == 6'h1)) || (wstate_nxt == WR_SBURST)))
	  MB_CTI_O_nxt = 3'b111;
	// set up wishbone burst (incrementing or constant address)
	else if (((wstate == WR_FIFO_CHECK) && (wstate_nxt == WR_BURST))
		 || ((wstate == WR_BURST) && MB_ACK_I))
	  MB_CTI_O_nxt = reg_s_con ? 3'b001 : 3'b010;
	// hold
	else
	  MB_CTI_O_nxt = MB_CTI_O;
	
	// MB_DAT_O
	MB_DAT_O = fifo_dout;
	
	
	// Other signals
	MB_WE_O = 1'b1;
	MB_LOCK_O = 1'b0;
     end
   
   generate
      if (MB_WB_DAT_WIDTH == 8) begin
	 
	 always @(*)
	   MB_SEL_O_nxt = 1'b1;
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/MB_ADR_O_nxt or iCount)
	   begin
	      if (iCount == 1)
		casez (MB_ADR_O_nxt[1:0])
		  2'b00: MB_SEL_O_nxt = 4'b1000;
		  2'b01: MB_SEL_O_nxt = 4'b0100;
		  2'b10: MB_SEL_O_nxt = 4'b0010;
		  2'b11: MB_SEL_O_nxt = 4'b0001;
		  default:
		    MB_SEL_O_nxt = 4'b1111;
		endcase
	      else if (iCount == 2)
		MB_SEL_O_nxt = MB_ADR_O_nxt[1] ? 4'b0011 : 4'b1100;
	      else
		MB_SEL_O_nxt = 4'b1111;
	   end
	 
      end
   endgenerate
   
   /*----------------------------------------------------------------------
    Logic to keep track of where we are in the transfer process
    ----------------------------------------------------------------------*/
   // Increment Count
   generate
      if (S_WB_DAT_WIDTH == 8) begin
	 assign iCount = 3'h1;
      end
      else begin
	 assign iCount = reg_incw ? 3'h4 : (reg_inchw ? 3'h2 : 3'h1);
      end
   endgenerate
   
   // Burst Count
   assign bCount = (reg_bt3 
		    ? (reg_bt2 
		       ? 6'h3f 
		       : (reg_bt1 
			  ? (reg_bt0 ? 6'h1f : 6'h0f)
			  : (reg_bt0 ? 6'h07 : 6'h03)))
		    : 6'h01
		    );
      
   // Burst Increment Count
   assign biCount = (reg_bt3 
		     ? (reg_bt2
			? iCount<<6
			: (reg_bt1 
			   ? (reg_bt0 ? iCount<<5 : iCount<<4) 
			   : (reg_bt0 ? iCount<<3 : iCount<<2)
			   )
			)
		     : iCount
		     );
   
   always @(/*AUTOSENSE*/MA_ACK_I or MB_ACK_I or bCount or biCount
	    or fifo_empty or iCount or rburst_count or reg_08_data
	    or reg_inchw or reg_incw or reg_start or rstate
	    or save_wburst_count or wburst_count or wstate
	    or xfer_length)
     begin
	// Transfer Length
	if (reg_start && (wstate == WR_IDLE))
	  xfer_length_nxt = reg_08_data;
	else if (MB_ACK_I && (wstate == WR_SINGLEB))
	  xfer_length_nxt = xfer_length - iCount;
	else if (wstate == WR_SETUPA)
	  xfer_length_nxt = (xfer_length >= biCount) ? (xfer_length - biCount) : 0;
	else
	  xfer_length_nxt = xfer_length;
	
	// Read-side Burst Count
	if (rstate == RD_IDLE)
	  rburst_count_nxt = wburst_count;
	else if ((rstate == RD_BURST) && MA_ACK_I)
	  rburst_count_nxt = rburst_count - 1'b1;
	else
	  rburst_count_nxt = rburst_count;
	
	// Write-side Burst Count
	if (wstate == WR_SETUPA)
	  wburst_count_nxt = ((xfer_length == 0)
			      ? 0
			      : ((xfer_length >= biCount) 
				 ? bCount 
				 : (xfer_length-1)>>(reg_incw ? 2 : (reg_inchw ? 1 : 0))));
	else if ((wstate == WR_RETRY) && fifo_empty)
	  wburst_count_nxt = save_wburst_count;
	else if (MB_ACK_I
		 && ((wstate == WR_SHORT) || (wstate == WR_BURST) || (wstate == WR_SBURST)))
	  wburst_count_nxt = wburst_count - 1'b1;
	else
	  wburst_count_nxt = wburst_count;
     end
   
   /*----------------------------------------------------------------------
    Logic to support a burst retry
    ----------------------------------------------------------------------*/
   always @(/*AUTOSENSE*/MA_ADR_O or MB_ADR_O or raddr_checkpoint
	    or reg_rdelay or retry_delay or rstate or rstate_nxt
	    or save_wburst_count or waddr_checkpoint
	    or wburst_count_nxt or wstate or wstate_nxt)
     begin
	// Write-side Saved Burst Count
	if (wstate == WR_SETUPA)
	  save_wburst_count_nxt = wburst_count_nxt;
	else
	  save_wburst_count_nxt = save_wburst_count;
	
	// Retry Delay
	if (((wstate != WR_RETRY) && (wstate_nxt == WR_RETRY))
	    || ((rstate == RD_SINGLEA) && (rstate_nxt == RD_SINGLE_RETRY)))
	  retry_delay_nxt = reg_rdelay;
	else if ((wstate == WR_RETRY) || (rstate == RD_SINGLE_RETRY))
	  retry_delay_nxt = retry_delay - 1'b1;
	else
	  retry_delay_nxt = retry_delay;
	
	// Read Address Checkpoint
	if ((rstate == RD_IDLE) && (rstate_nxt == RD_BURST))
	  raddr_checkpoint_nxt = MA_ADR_O;
	else
	  raddr_checkpoint_nxt = raddr_checkpoint;
	
	// Write Address Checkpoint
	if (wstate == WR_SETUPA)
	  waddr_checkpoint_nxt = MB_ADR_O;
	else
	  waddr_checkpoint_nxt = waddr_checkpoint;
     end
   
   /*----------------------------------------------------------------------
    Logic to indicate start/end of transfer and bursts
    ----------------------------------------------------------------------*/
   always @(/*AUTOSENSE*/MA_ERR_I or MB_ACK_I or MB_ERR_I or iCount
	    or retry_delay or wburst_count or wstate or xfer_length)
     begin
	if (((wstate == WR_SINGLEB) && (xfer_length > iCount) && MB_ACK_I)
	    || ((wstate == WR_SETUPB) && (wburst_count > 0))
	    || ((wstate == WR_RETRY) && (retry_delay == 8'b0)))
	  burst_start = 1'b1;
	else
	  burst_start = 1'b0;
	
	if (MB_ERR_I
	    || MA_ERR_I
	    || ((wstate == WR_SINGLEB) && (xfer_length == iCount) && MB_ACK_I)
	    || ((wstate == WR_SETUPB) && (wburst_count == 0)))
	  xfer_done = 1'b1;
	else
	  xfer_done = 1'b0;
     end

   /*----------------------------------------------------------------------
    Sequential Logic
    ----------------------------------------------------------------------*/
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       begin
	  rstate <= #UDLY RD_IDLE;
	  wstate <= #UDLY WR_IDLE;
	  xfer_length <= #UDLY 32'b0;
	  rburst_count <= #UDLY 6'b0;
	  wburst_count <= #UDLY 6'b0;
	  retry_delay <= #UDLY 8'b0;
	  reg_status <= #UDLY 1'b0;
	  MA_CYC_O <= #UDLY 1'b0;
	  MA_CYC_O_d <= #UDLY 1'b0;
	  MA_STB_O <= #UDLY 1'b0;
	  MA_CTI_O <= #UDLY 3'b0;
	  MA_ADR_O <= #UDLY 'b0;
	  MA_SEL_O <= #UDLY 'b0;
	  MB_CYC_O <= #UDLY 1'b0;
	  MB_CYC_O_d <= #UDLY 1'b0;
	  MB_STB_O <= #UDLY 1'b0;
	  MB_CTI_O <= #UDLY 3'b0;
	  MB_ADR_O <= #UDLY 'b0;
	  MB_SEL_O <= #UDLY 'b0;
	  raddr_checkpoint <= #UDLY 32'b0;
	  waddr_checkpoint <= #UDLY 32'b0;
	  save_wburst_count <= #UDLY 6'b0;
       end
     else
       begin
	  rstate <= #UDLY rstate_nxt;
	  wstate <= #UDLY wstate_nxt;
	  xfer_length <= #UDLY xfer_length_nxt;
	  rburst_count <= #UDLY rburst_count_nxt;
	  wburst_count <= #UDLY wburst_count_nxt;
	  retry_delay <= #UDLY retry_delay_nxt;
	  reg_status <= #UDLY reg_status_nxt;
	  MA_CYC_O <= #UDLY MA_CYC_O_nxt;
	  MA_CYC_O_d <= #UDLY MA_CYC_O;
	  MA_STB_O <= #UDLY MA_STB_O_nxt;
	  MA_CTI_O <= #UDLY MA_CTI_O_nxt;
	  MA_ADR_O <= #UDLY MA_ADR_O_nxt;
	  MA_SEL_O <= #UDLY MA_SEL_O_nxt;
	  MB_CYC_O <= #UDLY MB_CYC_O_nxt;
	  MB_CYC_O_d <= #UDLY MB_CYC_O;
	  MB_STB_O <= #UDLY MB_STB_O_nxt;
	  MB_CTI_O <= #UDLY MB_CTI_O_nxt;
	  MB_ADR_O <= #UDLY MB_ADR_O_nxt;
	  MB_SEL_O <= #UDLY MB_SEL_O_nxt; 
	  raddr_checkpoint <= #UDLY raddr_checkpoint_nxt;
	  waddr_checkpoint <= #UDLY waddr_checkpoint_nxt;
	  save_wburst_count <= #UDLY save_wburst_count_nxt;
       end

   /*----------------------------------------------------------------------
    FIFO Logic
    ----------------------------------------------------------------------*/
   reg fifo_rd_en, fifo_wr_en;
   always @(/*AUTOSENSE*/MA_ACK_I or MA_DAT_I or MB_ACK_I
	    or fifo_aempty or fifo_empty or rstate or wburst_count
	    or wstate)
     begin
	if (((wstate == WR_SINGLEA) && (fifo_empty == 1'b0))
	    || ((wstate == WR_FIFO_CHECK)
		&& (((fifo_empty == 1'b0) && (wburst_count == 6'h0))
		    || ((fifo_aempty == 1'b0) && (wburst_count >= 6'h1))))
	    || ((wstate == WR_BURST)
		&& (/*(MB_CYC_O_d == 1'b0)
		    ||*/ (MB_ACK_I && (wburst_count >= 6'h1))))
	    || ((wstate == WR_ERROR) && (fifo_empty == 1'b0))
	    || ((wstate == WR_RETRY) && (fifo_empty == 1'b0)))
	  fifo_rd_en = 1'b1;
	else
	  fifo_rd_en = 1'b0;
	
	if (MA_ACK_I
	    && ((rstate == RD_SINGLEA) || (rstate == RD_BURST)))
	  fifo_wr_en = 1'b1;
	else
	  fifo_wr_en = 1'b0;
	
	fifo_din = MA_DAT_I;
     end
   
   generate
      if (lat_family == "SC" || lat_family == "SCM") begin
	 
         pmi_fifo_dc 
	   #(.pmi_data_width_w(MA_WB_DAT_WIDTH),
	     .pmi_data_width_r(MA_WB_DAT_WIDTH),
	     .pmi_data_depth_w(64),
	     .pmi_data_depth_r(64),
	     .pmi_full_flag(64),
	     .pmi_empty_flag(0),
	     .pmi_almost_full_flag(60),
	     .pmi_almost_empty_flag(4),
	     .pmi_regmode("noreg"),
	     .pmi_family(`LATTICE_FAMILY),
	     .module_type("pmi_fifo_dc"),
             .pmi_implementation(FIFO_IMPLEMENTATION))
	 dma_fifo_dc 
	   (
            .Data(fifo_din),
            .WrClock    (CLK_I),
	    .RdClock    (CLK_I),
	    .WrEn	(fifo_wr_en),
	    .RdEn	(fifo_rd_en),
	    .Reset	(RST_I),
	    .RPReset    (RST_I),
	    .Q	        (fifo_dout),
	    .Empty	(fifo_empty),
	    .Full	(),
	    .AlmostEmpty(),
	    .AlmostFull ());
      
      end else if (lat_family == "MachXO2") begin
	      
	 pmi_fifo_dc 
	   #(.pmi_data_width_w (MA_WB_DAT_WIDTH),
	     .pmi_data_width_r (MA_WB_DAT_WIDTH),
	     .pmi_data_depth_w (64),
	     .pmi_data_depth_r (64),
	     .pmi_full_flag (64),
	     .pmi_empty_flag (0),
	     .pmi_almost_full_flag (60),
	     .pmi_almost_empty_flag (1),
	     .pmi_regmode ("noreg"),
	     .pmi_family ("XO2"),
	     .module_type ("pmi_fifo_dc"),
             .pmi_implementation (FIFO_IMPLEMENTATION))
	 dma_fifo 
	   (.Data 	(fifo_din),
	    .WrClock	(CLK_I),
	    .RdClock	(CLK_I),
	    .WrEn	(fifo_wr_en),
	    .RdEn	(fifo_rd_en),
	    .Reset	(RST_I),
	    .RPReset	(RST_I),
	    .Q	        (fifo_dout),
	    .Empty	(fifo_empty),
	    .Full	(),
	    .AlmostEmpty(fifo_aempty),
	    .AlmostFull ());

      end else begin
	      
	 pmi_fifo 
	   #(.pmi_data_width(MA_WB_DAT_WIDTH),
	     .pmi_data_depth(64),
	     .pmi_full_flag(64),
	     .pmi_empty_flag(0),
	     .pmi_almost_full_flag(60),
	     .pmi_almost_empty_flag(1),
	     .pmi_regmode("noreg"),
	     .pmi_family(`LATTICE_FAMILY),
	     .module_type("pmi_fifo"),
             .pmi_implementation(FIFO_IMPLEMENTATION))
	 dma_fifo 
	   (.Data 	(fifo_din),
	    .Clock	(CLK_I),
	    .WrEn	(fifo_wr_en),
	    .RdEn	(fifo_rd_en),
	    .Reset	(RST_I),
	    .Q	        (fifo_dout),
	    .Empty	(fifo_empty),
	    .Full	(),
	    .AlmostEmpty(fifo_aempty),
	    .AlmostFull ());

      end

   endgenerate
   
endmodule

`endif //  `ifndef MASTER_CTRL_FILE
