// =============================================================================
//                           COPYRIGHT NOTICE
// Copyright 2006 (c) Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// This confidential and proprietary software may be used only as authorised by
// a licensing agreement from Lattice Semiconductor Corporation.
// The entire notice above must be reproduced on all authorized copies and
// copies may only be made to the extent permitted by a licensing agreement from
// Lattice Semiconductor Corporation.
//
// Lattice Semiconductor Corporation        TEL : 1-800-Lattice (USA and Canada)
// 5555 NE Moore Court                            408-826-6000 (other locations)
// Hillsboro, OR 97124                     web  : http://www.latticesemi.com/
// U.S.A                                   email: techsupport@latticesemi.com
// =============================================================================/
//                         FILE DETAILS
// Project          : LM32 DMA Component
// File             : wb_dma_ctrl.v
// Title            : DMA controller top file
// Dependencies     : None
// Version          : 7.0
//                  : Initial Release
// Version          : 7.0SP2, 3.0
//   1. Read and Write channel of DMA controller are working in parallel,
//      due to that now as soon as FIFO is not empty write channel of the DMA
//      controller start writing data to the slave.
//   2. Burst Size supported by DMA controller is increased to support bigger
//      burst (from current value of 4 and 8 to 16 and 32). Now 4 different type
//      of burst sizes are supported by the DMA controller 4, 8, 16 and 32. 
//      For this Burst Size field of the control register is increased to 2 bits.
//   3. Glitch is removed on the S_ACK_O signal. 
// Version          : 3.1
//                  : Make DMA Engine compliant to Rule 3.100 of Wishbone Spec
//                  : which defines alignement of bytes in sub-word transfers.
// =============================================================================

`ifndef WB_DMA_CTRL_FILE
`define WB_DMA_CTRL_FILE
`include "system_conf.v"
module wb_dma_ctrl #(parameter LENGTH_WIDTH = 16,
                     parameter FIFO_IMPLEMENTATION = "EBR")
(
         //master read port
         MA_ADR_O,    //32bits
         MA_WE_O,
         MA_SEL_O,    //4bits
         MA_STB_O,
         MA_CYC_O,
         MA_LOCK_O,
         MA_CTI_O,
         MA_BTE_O,
         MA_DAT_I,    //32bits
         MA_DAT_O,    //32bits
         MA_ACK_I,
         MA_ERR_I,
         MA_RTY_I,
         //master write port
         MB_ADR_O,    //32bits
         MB_DAT_O,    //32bits
         MB_WE_O,
         MB_SEL_O,    //4bits
         MB_STB_O,
         MB_CYC_O,
         MB_LOCK_O,
         MB_CTI_O,
         MB_BTE_O,
         MB_DAT_I,    //32bits
         MB_ACK_I,
         MB_ERR_I,
         MB_RTY_I,
         //slave port
         S_ADR_I,    //32bits
         S_DAT_I,    //32bits
         S_WE_I,
         S_STB_I,
         S_CYC_I,
         S_SEL_I,
         S_LOCK_I,
         S_CTI_I,
         S_BTE_I,
         S_DAT_O,    //32bits
         S_ACK_O,
         S_ERR_O,
         S_RTY_O,
         S_INT_O,
         //system clock and reset
         CLK_I,
         RST_I
         );
   //master read port
   output [31:0]    MA_ADR_O;    //32bits
   output           MA_WE_O;
   output [3:0]     MA_SEL_O;    //4bits
   output           MA_STB_O;
   output           MA_CYC_O;
   output           MA_LOCK_O;
   output [2:0]     MA_CTI_O;
   output [1:0]     MA_BTE_O;   
   output [31:0]    MA_DAT_O;    //32bits
   input [31:0]     MA_DAT_I;    //32bits
   input            MA_ACK_I;
   input            MA_ERR_I;
   input            MA_RTY_I;
   //master write port
   output [31:0]    MB_ADR_O;    //32bits
   output [31:0]    MB_DAT_O;    //32bits
   output           MB_WE_O;
   output [3:0]     MB_SEL_O;    //4bits
   output           MB_STB_O;
   output           MB_CYC_O;
   output [2:0]     MB_CTI_O;
   output           MB_LOCK_O;
   output [1:0]     MB_BTE_O;   
   input [31:0]     MB_DAT_I;    //32bits
   input            MB_ACK_I;
   input            MB_ERR_I;
   input            MB_RTY_I;
   //slave port
   input [31:0]     S_ADR_I;    //32bits
   input [31:0]     S_DAT_I;    //32bits
   input            S_WE_I;
   input            S_STB_I;
   input            S_CYC_I;
   input [2:0]      S_CTI_I;
   input [1:0]      S_BTE_I;   
   input [3:0]      S_SEL_I;
   input            S_LOCK_I;   
   output [31:0]    S_DAT_O;    //32bits
   output           S_ACK_O;
   output           S_ERR_O;
   output           S_RTY_O;
   output           S_INT_O;
   //system clock and reset
   input            CLK_I;
   input            RST_I;

   wire [31:0]      MA_DAT_O = 0;
   wire [1:0]       MA_BTE_O = 0;
   wire             MA_LOCK_O;
   
   wire [1:0]       MB_BTE_O = 0;
   wire             MB_LOCK_O;

   wire             S_ERR_O = 0;
   wire             S_RTY_O = 0;
   
   wire [LENGTH_WIDTH-1:0]   data_length;//read back data
   wire [2:0]   incr_unit;
   wire [31:0]  reg_00_data;
   wire [31:0]  reg_04_data;
   wire [3:0] 	M_SEL_O;
   
   //slave port:master write/read data to/from register file.
   SLAVE_REG  #(.LENGTH_WIDTH(LENGTH_WIDTH),
                .FIFO_IMPLEMENTATION(FIFO_IMPLEMENTATION))  SLAVE_REG(
           .S_ADR_I            (S_ADR_I        ),
           .S_DAT_I            (S_DAT_I        ),
           .S_WE_I             (S_WE_I         ),
           .S_STB_I            (S_STB_I        ),
           .S_CYC_I            (S_CYC_I        ),
           .S_CTI_I            (S_CTI_I        ),
           .S_DAT_O            (S_DAT_O        ),
           .S_ACK_O            (S_ACK_O        ),
           .S_INT_O            (S_INT_O        ),
           //Master Addr
           .M_SEL_O            (M_SEL_O        ),
//            .MA_SEL_O           (MA_SEL_O       ),
//            .MB_SEL_O           (MB_SEL_O       ),
           //internal signals
           .reg_start          (reg_start      ),
           .reg_status         (reg_status     ),
           .reg_interrupt      (reg_interrupt  ),
           .reg_busy           (reg_busy       ),
           .data_length        (data_length    ),
           .reg_cntlg          (reg_cntlg      ),
	   .reg_bt2            (reg_bt2        ), 
           .reg_bt1            (reg_bt1        ),
           .reg_bt0            (reg_bt0        ),
           .reg_s_con          (reg_s_con      ),
           .reg_d_con          (reg_d_con      ),
           .incr_unit          (incr_unit      ),
           .reg_00_data        (reg_00_data    ),
           .reg_04_data        (reg_04_data    ),
           //system clock and reset
           .CLK_I              (CLK_I          ),
           .RST_I              (RST_I          )
           );
   
   //Master control
   MASTER_CTRL   #(.LENGTH_WIDTH(LENGTH_WIDTH),
                   .FIFO_IMPLEMENTATION(FIFO_IMPLEMENTATION))   MASTER_CTRL(
               //master read port
               .MA_ADR_O           (MA_ADR_O       ),
               .MA_SEL_O           (MA_SEL_O       ),
               .MA_WE_O            (MA_WE_O        ),
               .MA_STB_O           (MA_STB_O       ),
               .MA_CYC_O           (MA_CYC_O       ),
               .MA_CTI_O           (MA_CTI_O       ),
	       .MA_LOCK_O          (MA_LOCK_O      ),
               .MA_DAT_I           (MA_DAT_I       ),    //32bits
               .MA_ACK_I           (MA_ACK_I       ),
               .MA_ERR_I           (MA_ERR_I       ),
               .MA_RTY_I           (MA_RTY_I       ),
               //master write port
               .MB_ADR_O           (MB_ADR_O       ),
               .MB_SEL_O           (MB_SEL_O       ),
               .MB_DAT_O           (MB_DAT_O       ),    //32bits
               .MB_WE_O            (MB_WE_O        ),
               .MB_STB_O           (MB_STB_O       ),
               .MB_CYC_O           (MB_CYC_O       ),
               .MB_CTI_O           (MB_CTI_O       ),
	       .MB_LOCK_O          (MB_LOCK_O      ),
               .MB_ACK_I           (MB_ACK_I       ),
               .MB_ERR_I           (MB_ERR_I       ),
               .MB_RTY_I           (MB_RTY_I       ),
               //register interface
               .M_SEL_O            (M_SEL_O        ),
               .reg_start          (reg_start      ),
               .reg_status         (reg_status     ),
               .reg_interrupt      (reg_interrupt  ),
               .reg_busy           (reg_busy       ),
               .data_length        (data_length    ),
               .reg_cntlg          (reg_cntlg      ),
	       .reg_bt2            (reg_bt2        ),
               .reg_bt1            (reg_bt1        ),
               .reg_bt0            (reg_bt0        ),
               .reg_s_con          (reg_s_con      ),
               .reg_d_con          (reg_d_con      ),
               .incr_unit          (incr_unit      ),
               .reg_00_data        (reg_00_data    ),
               .reg_04_data        (reg_04_data    ),
               //system clock and reset
               .CLK_I              (CLK_I          ),
               .RST_I              (RST_I          )
               );
endmodule // WB_DMA_CTRL
`endif // WB_DMA_CTRL_FILE
