// =============================================================================
//                           COPYRIGHT NOTICE
// Copyright 2006 (c) Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// This confidential and proprietary software may be used only as authorised by
// a licensing agreement from Lattice Semiconductor Corporation.
// The entire notice above must be reproduced on all authorized copies and
// copies may only be made to the extent permitted by a licensing agreement from
// Lattice Semiconductor Corporation.
//
// Lattice Semiconductor Corporation        TEL : 1-800-Lattice (USA and Canada)
// 5555 NE Moore Court                            408-826-6000 (other locations)
// Hillsboro, OR 97124                     web  : http://www.latticesemi.com/
// U.S.A                                   email: techsupport@latticesemi.com
// =============================================================================/
//                         FILE DETAILS
// Project          : LatticeMico32
// File             : lm32_monitor_ram.v
// Title            : LM32 monitor RAM, hold the load/monitor code
// Dependencies     : system_conf.v
// Version          : 6.1.17
//                  : Initial Release
// Version          : version 7.0 (7.0SP2)
//                  : No Change
//                  : version 7.1: updated to fix r0 not being zero
//                  :     when hitting a breakpoint (CR 38134)
//                  : version 7.2: updated to also store ip/im registers
//                  :     and update im register when restoring stack
// =============================================================================
`include "system_conf.v"

`timescale 1 ns / 1 ps
module lm32_monitor_ram (DataInA, DataInB, AddressA, AddressB, ClockA, 
			 ClockB, ClockEnA, ClockEnB, WrA, WrB, ResetA, ResetB, QA, QB);
   input [31:0] DataInA;
   input [31:0] DataInB;
   input [8:0] 	AddressA;
   input [8:0] 	AddressB;
   input 	ClockA;
   input 	ClockB;
   input 	ClockEnA;
   input 	ClockEnB;
   input 	WrA;
   input 	WrB;
   input 	ResetA;
   input 	ResetB;
   output [31:0] QA;
   output [31:0] QB;

   parameter 	 lat_family = `LATTICE_FAMILY;
   
   generate
      if (lat_family == "ECP3") begin

/* Verilog netlist generated by SCUBA ispLever_v8.0_ALPHA (69) */
/* Module Version: 7.0 */
/* c:\ispTOOLS8_0\ispFPGA\bin\nt\scuba.exe -w -lang verilog -synth synplify -bus_exp 7 -bb -arch ep5c00 -type bram -wp 11 -rp 1010 -addr_width 9 -data_width 32 -num_rows 512 -gsr DISABLED -writemode NORMAL -resetmode SYNC -memfile ../../lm32_monitor.mem -memformat hex -n lm32_monitor_ram -e  */
/* Tue Jun 16 18:01:57 2009 */

    defparam lm32_monitor_ram_0_0_1.INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_19 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_18 = "0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_17 = "0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_16 = "0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_15 = "0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_14 = "0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_13 = "0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_12 = "0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_11 = "0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_10 = "0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0F = "0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0E = "0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0D = "0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0C = "0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0B = "0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0A = "0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_09 = "0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_08 = "0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_07 = "0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_06 = "0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_05 = "0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_04 = "0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_03 = "0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_02 = "0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_01 = "0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000" ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_00 = "0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000" ;
    defparam lm32_monitor_ram_0_0_1.CSDECODE_B = "0b000" ;
    defparam lm32_monitor_ram_0_0_1.CSDECODE_A = "0b000" ;
    defparam lm32_monitor_ram_0_0_1.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_0_0_1.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_0_0_1.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_0_0_1.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_0_0_1.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_0_0_1.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_0_0_1.DATA_WIDTH_A = 18 ;
    DP16KC lm32_monitor_ram_0_0_1 (.DIA0(DataInA[0]), .DIA1(DataInA[1]), 
        .DIA2(DataInA[2]), .DIA3(DataInA[3]), .DIA4(DataInA[4]), .DIA5(DataInA[5]), 
        .DIA6(DataInA[6]), .DIA7(DataInA[7]), .DIA8(DataInA[8]), .DIA9(DataInA[9]), 
        .DIA10(DataInA[10]), .DIA11(DataInA[11]), .DIA12(DataInA[12]), .DIA13(DataInA[13]), 
        .DIA14(DataInA[14]), .DIA15(DataInA[15]), .DIA16(DataInA[16]), .DIA17(DataInA[17]), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), 
        .OCEA(ClockEnA), .WEA(WrA), .CSA0(scuba_vlo), .CSA1(scuba_vlo), 
        .CSA2(scuba_vlo), .RSTA(ResetA), .DIB0(DataInB[0]), .DIB1(DataInB[1]), 
        .DIB2(DataInB[2]), .DIB3(DataInB[3]), .DIB4(DataInB[4]), .DIB5(DataInB[5]), 
        .DIB6(DataInB[6]), .DIB7(DataInB[7]), .DIB8(DataInB[8]), .DIB9(DataInB[9]), 
        .DIB10(DataInB[10]), .DIB11(DataInB[11]), .DIB12(DataInB[12]), .DIB13(DataInB[13]), 
        .DIB14(DataInB[14]), .DIB15(DataInB[15]), .DIB16(DataInB[16]), .DIB17(DataInB[17]), 
        .ADB0(scuba_vhi), .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), 
        .ADB4(AddressB[0]), .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), 
        .ADB8(AddressB[4]), .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), 
        .ADB12(AddressB[8]), .ADB13(scuba_vlo), .CEB(ClockEnB), .CLKB(ClockB), 
        .OCEB(ClockEnB), .WEB(WrB), .CSB0(scuba_vlo), .CSB1(scuba_vlo), 
        .CSB2(scuba_vlo), .RSTB(ResetB), .DOA0(QA[0]), .DOA1(QA[1]), .DOA2(QA[2]), 
        .DOA3(QA[3]), .DOA4(QA[4]), .DOA5(QA[5]), .DOA6(QA[6]), .DOA7(QA[7]), 
        .DOA8(QA[8]), .DOA9(QA[9]), .DOA10(QA[10]), .DOA11(QA[11]), .DOA12(QA[12]), 
        .DOA13(QA[13]), .DOA14(QA[14]), .DOA15(QA[15]), .DOA16(QA[16]), 
        .DOA17(QA[17]), .DOB0(QB[0]), .DOB1(QB[1]), .DOB2(QB[2]), .DOB3(QB[3]), 
        .DOB4(QB[4]), .DOB5(QB[5]), .DOB6(QB[6]), .DOB7(QB[7]), .DOB8(QB[8]), 
        .DOB9(QB[9]), .DOB10(QB[10]), .DOB11(QB[11]), .DOB12(QB[12]), .DOB13(QB[13]), 
        .DOB14(QB[14]), .DOB15(QB[15]), .DOB16(QB[16]), .DOB17(QB[17]))
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis RESETMODE="SYNC" */;

    VHI scuba_vhi_inst (.Z(scuba_vhi));

    VLO scuba_vlo_inst (.Z(scuba_vlo));

    defparam lm32_monitor_ram_0_1_0.INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_19 = "0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_18 = "0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_17 = "0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_16 = "0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_15 = "0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_14 = "0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_13 = "0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_12 = "0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_11 = "0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_10 = "0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0F = "0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0E = "0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0D = "0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0C = "0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0B = "0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0A = "0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_09 = "0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_08 = "0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_07 = "0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_06 = "0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_05 = "0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_04 = "0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_03 = "0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_02 = "0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_01 = "0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_00 = "0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600" ;
    defparam lm32_monitor_ram_0_1_0.CSDECODE_B = "0b000" ;
    defparam lm32_monitor_ram_0_1_0.CSDECODE_A = "0b000" ;
    defparam lm32_monitor_ram_0_1_0.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_0_1_0.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_0_1_0.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_0_1_0.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_0_1_0.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_0_1_0.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_0_1_0.DATA_WIDTH_A = 18 ;
    DP16KC lm32_monitor_ram_0_1_0 (.DIA0(DataInA[18]), .DIA1(DataInA[19]), 
        .DIA2(DataInA[20]), .DIA3(DataInA[21]), .DIA4(DataInA[22]), .DIA5(DataInA[23]), 
        .DIA6(DataInA[24]), .DIA7(DataInA[25]), .DIA8(DataInA[26]), .DIA9(DataInA[27]), 
        .DIA10(DataInA[28]), .DIA11(DataInA[29]), .DIA12(DataInA[30]), .DIA13(DataInA[31]), 
        .DIA14(scuba_vlo), .DIA15(scuba_vlo), .DIA16(scuba_vlo), .DIA17(scuba_vlo), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), 
        .OCEA(ClockEnA), .WEA(WrA), .CSA0(scuba_vlo), .CSA1(scuba_vlo), 
        .CSA2(scuba_vlo), .RSTA(ResetA), .DIB0(DataInB[18]), .DIB1(DataInB[19]), 
        .DIB2(DataInB[20]), .DIB3(DataInB[21]), .DIB4(DataInB[22]), .DIB5(DataInB[23]), 
        .DIB6(DataInB[24]), .DIB7(DataInB[25]), .DIB8(DataInB[26]), .DIB9(DataInB[27]), 
        .DIB10(DataInB[28]), .DIB11(DataInB[29]), .DIB12(DataInB[30]), .DIB13(DataInB[31]), 
        .DIB14(scuba_vlo), .DIB15(scuba_vlo), .DIB16(scuba_vlo), .DIB17(scuba_vlo), 
        .ADB0(scuba_vhi), .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), 
        .ADB4(AddressB[0]), .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), 
        .ADB8(AddressB[4]), .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), 
        .ADB12(AddressB[8]), .ADB13(scuba_vlo), .CEB(ClockEnB), .CLKB(ClockB), 
        .OCEB(ClockEnB), .WEB(WrB), .CSB0(scuba_vlo), .CSB1(scuba_vlo), 
        .CSB2(scuba_vlo), .RSTB(ResetB), .DOA0(QA[18]), .DOA1(QA[19]), .DOA2(QA[20]), 
        .DOA3(QA[21]), .DOA4(QA[22]), .DOA5(QA[23]), .DOA6(QA[24]), .DOA7(QA[25]), 
        .DOA8(QA[26]), .DOA9(QA[27]), .DOA10(QA[28]), .DOA11(QA[29]), .DOA12(QA[30]), 
        .DOA13(QA[31]), .DOA14(), .DOA15(), .DOA16(), .DOA17(), .DOB0(QB[18]), 
        .DOB1(QB[19]), .DOB2(QB[20]), .DOB3(QB[21]), .DOB4(QB[22]), .DOB5(QB[23]), 
        .DOB6(QB[24]), .DOB7(QB[25]), .DOB8(QB[26]), .DOB9(QB[27]), .DOB10(QB[28]), 
        .DOB11(QB[29]), .DOB12(QB[30]), .DOB13(QB[31]), .DOB14(), .DOB15(), 
        .DOB16(), .DOB17())
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis RESETMODE="SYNC" */;



    // exemplar begin
    // exemplar attribute lm32_monitor_ram_0_0_1 MEM_LPC_FILE lm32_monitor_ram.lpc
    // exemplar attribute lm32_monitor_ram_0_0_1 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_0_0_1 RESETMODE SYNC
    // exemplar attribute lm32_monitor_ram_0_1_0 MEM_LPC_FILE lm32_monitor_ram.lpc
    // exemplar attribute lm32_monitor_ram_0_1_0 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_0_1_0 RESETMODE SYNC
    // exemplar end

      end else if (lat_family == "EC" || lat_family == "ECP" || lat_family == "XP") begin

/* Verilog netlist generated by SCUBA ispLever_v8.0_ALPHA (69) */
/* Module Version: 7.0 */
/* c:\ispTOOLS8_0\ispFPGA\bin\nt\scuba.exe -w -lang verilog -synth synplify -bus_exp 7 -bb -arch ep5g00 -type bram -wp 11 -rp 1010 -addr_width 9 -data_width 32 -num_rows 512 -gsr DISABLED -writemode NORMAL -resetmode SYNC -memfile ../../lm32_monitor.mem -memformat hex -n lm32_monitor_ram -e  */
/* Tue Jun 16 18:01:57 2009 */

    // synopsys translate_off
    defparam lm32_monitor_ram_0_0_1.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_19 = 320'h0000000000000000000000000000000000000000000000000000000000000000000000000003FF81 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_18 = 320'h300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_17 = 320'h3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_16 = 320'h068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_15 = 320'h3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_14 = 320'h00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_13 = 320'h070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_12 = 320'h200081000C0001030014200181001C00020300240000000000000001000000000000000000010000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_11 = 320'h100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_10 = 320'h30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0F = 320'h30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0E = 320'h1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0D = 320'h100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0C = 320'h0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0B = 320'h300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_0A = 320'h300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_09 = 320'h20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_08 = 320'h300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_07 = 320'h300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_06 = 320'h1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_05 = 320'h1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_04 = 320'h1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_03 = 320'h0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_02 = 320'h0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_01 = 320'h00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000 ;
    defparam lm32_monitor_ram_0_0_1.INITVAL_00 = 320'h00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000 ;
    defparam lm32_monitor_ram_0_0_1.CSDECODE_B = "000" ;
    defparam lm32_monitor_ram_0_0_1.CSDECODE_A = "000" ;
    defparam lm32_monitor_ram_0_0_1.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_0_0_1.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_0_0_1.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_0_0_1.RESETMODE = "SYNC" ;
    defparam lm32_monitor_ram_0_0_1.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_0_0_1.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_0_0_1.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_0_0_1.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP8KA lm32_monitor_ram_0_0_1 (.CEA(ClockEnA), .CLKA(ClockA), .WEA(WrA), 
        .CSA0(scuba_vlo), .CSA1(scuba_vlo), .CSA2(scuba_vlo), .RSTA(ResetA), 
        .CEB(ClockEnB), .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), .CSB1(scuba_vlo), 
        .CSB2(scuba_vlo), .RSTB(ResetB), .DIA0(DataInA[0]), .DIA1(DataInA[1]), 
        .DIA2(DataInA[2]), .DIA3(DataInA[3]), .DIA4(DataInA[4]), .DIA5(DataInA[5]), 
        .DIA6(DataInA[6]), .DIA7(DataInA[7]), .DIA8(DataInA[8]), .DIA9(DataInA[9]), 
        .DIA10(DataInA[10]), .DIA11(DataInA[11]), .DIA12(DataInA[12]), .DIA13(DataInA[13]), 
        .DIA14(DataInA[14]), .DIA15(DataInA[15]), .DIA16(DataInA[16]), .DIA17(DataInA[17]), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .DIB0(DataInB[0]), .DIB1(DataInB[1]), .DIB2(DataInB[2]), 
        .DIB3(DataInB[3]), .DIB4(DataInB[4]), .DIB5(DataInB[5]), .DIB6(DataInB[6]), 
        .DIB7(DataInB[7]), .DIB8(DataInB[8]), .DIB9(DataInB[9]), .DIB10(DataInB[10]), 
        .DIB11(DataInB[11]), .DIB12(DataInB[12]), .DIB13(DataInB[13]), .DIB14(DataInB[14]), 
        .DIB15(DataInB[15]), .DIB16(DataInB[16]), .DIB17(DataInB[17]), .ADB0(scuba_vhi), 
        .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), .ADB4(AddressB[0]), 
        .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), .ADB8(AddressB[4]), 
        .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), .ADB12(AddressB[8]), 
        .DOA0(QA[0]), .DOA1(QA[1]), .DOA2(QA[2]), .DOA3(QA[3]), .DOA4(QA[4]), 
        .DOA5(QA[5]), .DOA6(QA[6]), .DOA7(QA[7]), .DOA8(QA[8]), .DOA9(QA[9]), 
        .DOA10(QA[10]), .DOA11(QA[11]), .DOA12(QA[12]), .DOA13(QA[13]), 
        .DOA14(QA[14]), .DOA15(QA[15]), .DOA16(QA[16]), .DOA17(QA[17]), 
        .DOB0(QB[0]), .DOB1(QB[1]), .DOB2(QB[2]), .DOB3(QB[3]), .DOB4(QB[4]), 
        .DOB5(QB[5]), .DOB6(QB[6]), .DOB7(QB[7]), .DOB8(QB[8]), .DOB9(QB[9]), 
        .DOB10(QB[10]), .DOB11(QB[11]), .DOB12(QB[12]), .DOB13(QB[13]), 
        .DOB14(QB[14]), .DOB15(QB[15]), .DOB16(QB[16]), .DOB17(QB[17]))
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81" */
             /* synthesis INITVAL_18="0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000" */
             /* synthesis INITVAL_17="0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000" */
             /* synthesis INITVAL_16="0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1" */
             /* synthesis INITVAL_15="0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012" */
             /* synthesis INITVAL_14="0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800" */
             /* synthesis INITVAL_13="0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004" */
             /* synthesis INITVAL_12="0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000" */
             /* synthesis INITVAL_11="0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000" */
             /* synthesis INITVAL_10="0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010" */
             /* synthesis INITVAL_0F="0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3" */
             /* synthesis INITVAL_0E="0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED" */
             /* synthesis INITVAL_0D="0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000" */
             /* synthesis INITVAL_0C="0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078" */
             /* synthesis INITVAL_0B="0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034" */
             /* synthesis INITVAL_0A="0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098" */
             /* synthesis INITVAL_09="0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054" */
             /* synthesis INITVAL_08="0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014" */
             /* synthesis INITVAL_07="0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF" */
             /* synthesis INITVAL_06="0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C" */
             /* synthesis INITVAL_05="0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C" */
             /* synthesis INITVAL_04="0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000" */
             /* synthesis INITVAL_03="0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000" */
             /* synthesis INITVAL_02="0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000" */
             /* synthesis INITVAL_01="0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000" */
             /* synthesis INITVAL_00="0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000" */
             /* synthesis CSDECODE_B="000" */
             /* synthesis CSDECODE_A="000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;

    VHI scuba_vhi_inst (.Z(scuba_vhi));

    VLO scuba_vlo_inst (.Z(scuba_vlo));

    // synopsys translate_off
    defparam lm32_monitor_ram_0_1_0.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_19 = 320'h000000000000000000000000000000000000000000000000000000000000000000000000000038FF ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_18 = 320'h034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_17 = 320'h038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_16 = 320'h02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_15 = 320'h03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_14 = 320'h0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_13 = 320'h024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_12 = 320'h00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_11 = 320'h00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_10 = 320'h00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0F = 320'h016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0E = 320'h010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0D = 320'h016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0C = 320'h011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0B = 320'h00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_0A = 320'h00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_09 = 320'h0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_08 = 320'h00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_07 = 320'h00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_06 = 320'h00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_05 = 320'h016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_04 = 320'h016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_03 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_02 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_01 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_0_1_0.INITVAL_00 = 320'h0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600 ;
    defparam lm32_monitor_ram_0_1_0.CSDECODE_B = "000" ;
    defparam lm32_monitor_ram_0_1_0.CSDECODE_A = "000" ;
    defparam lm32_monitor_ram_0_1_0.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_0_1_0.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_0_1_0.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_0_1_0.RESETMODE = "SYNC" ;
    defparam lm32_monitor_ram_0_1_0.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_0_1_0.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_0_1_0.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_0_1_0.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP8KA lm32_monitor_ram_0_1_0 (.CEA(ClockEnA), .CLKA(ClockA), .WEA(WrA), 
        .CSA0(scuba_vlo), .CSA1(scuba_vlo), .CSA2(scuba_vlo), .RSTA(ResetA), 
        .CEB(ClockEnB), .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), .CSB1(scuba_vlo), 
        .CSB2(scuba_vlo), .RSTB(ResetB), .DIA0(DataInA[18]), .DIA1(DataInA[19]), 
        .DIA2(DataInA[20]), .DIA3(DataInA[21]), .DIA4(DataInA[22]), .DIA5(DataInA[23]), 
        .DIA6(DataInA[24]), .DIA7(DataInA[25]), .DIA8(DataInA[26]), .DIA9(DataInA[27]), 
        .DIA10(DataInA[28]), .DIA11(DataInA[29]), .DIA12(DataInA[30]), .DIA13(DataInA[31]), 
        .DIA14(scuba_vlo), .DIA15(scuba_vlo), .DIA16(scuba_vlo), .DIA17(scuba_vlo), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .DIB0(DataInB[18]), .DIB1(DataInB[19]), .DIB2(DataInB[20]), 
        .DIB3(DataInB[21]), .DIB4(DataInB[22]), .DIB5(DataInB[23]), .DIB6(DataInB[24]), 
        .DIB7(DataInB[25]), .DIB8(DataInB[26]), .DIB9(DataInB[27]), .DIB10(DataInB[28]), 
        .DIB11(DataInB[29]), .DIB12(DataInB[30]), .DIB13(DataInB[31]), .DIB14(scuba_vlo), 
        .DIB15(scuba_vlo), .DIB16(scuba_vlo), .DIB17(scuba_vlo), .ADB0(scuba_vhi), 
        .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), .ADB4(AddressB[0]), 
        .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), .ADB8(AddressB[4]), 
        .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), .ADB12(AddressB[8]), 
        .DOA0(QA[18]), .DOA1(QA[19]), .DOA2(QA[20]), .DOA3(QA[21]), .DOA4(QA[22]), 
        .DOA5(QA[23]), .DOA6(QA[24]), .DOA7(QA[25]), .DOA8(QA[26]), .DOA9(QA[27]), 
        .DOA10(QA[28]), .DOA11(QA[29]), .DOA12(QA[30]), .DOA13(QA[31]), 
        .DOA14(), .DOA15(), .DOA16(), .DOA17(), .DOB0(QB[18]), .DOB1(QB[19]), 
        .DOB2(QB[20]), .DOB3(QB[21]), .DOB4(QB[22]), .DOB5(QB[23]), .DOB6(QB[24]), 
        .DOB7(QB[25]), .DOB8(QB[26]), .DOB9(QB[27]), .DOB10(QB[28]), .DOB11(QB[29]), 
        .DOB12(QB[30]), .DOB13(QB[31]), .DOB14(), .DOB15(), .DOB16(), .DOB17())
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF" */
             /* synthesis INITVAL_18="0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482" */
             /* synthesis INITVAL_17="0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03" */
             /* synthesis INITVAL_16="0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF" */
             /* synthesis INITVAL_15="0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10" */
             /* synthesis INITVAL_14="0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70" */
             /* synthesis INITVAL_13="0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7" */
             /* synthesis INITVAL_12="0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418" */
             /* synthesis INITVAL_11="0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84" */
             /* synthesis INITVAL_10="0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4" */
             /* synthesis INITVAL_0F="0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF" */
             /* synthesis INITVAL_0E="0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF" */
             /* synthesis INITVAL_0D="0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478" */
             /* synthesis INITVAL_0C="0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7" */
             /* synthesis INITVAL_0B="0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3" */
             /* synthesis INITVAL_0A="0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7" */
             /* synthesis INITVAL_09="0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5" */
             /* synthesis INITVAL_08="0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1" */
             /* synthesis INITVAL_07="0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808" */
             /* synthesis INITVAL_06="0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE" */
             /* synthesis INITVAL_05="0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA" */
             /* synthesis INITVAL_04="0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8" */
             /* synthesis INITVAL_03="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_02="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_01="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_00="0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600" */
             /* synthesis CSDECODE_B="000" */
             /* synthesis CSDECODE_A="000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;



    // exemplar begin
    // exemplar attribute lm32_monitor_ram_0_0_1 MEM_LPC_FILE lm32_monitor_ram.lpc
    // exemplar attribute lm32_monitor_ram_0_0_1 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_19 0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_18 0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_17 0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_16 0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_15 0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_14 0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_13 0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_12 0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_11 0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_10 0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0F 0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0E 0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0D 0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0C 0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0B 0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_0A 0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_09 0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_08 0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_07 0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_06 0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_05 0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_04 0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_03 0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_02 0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_01 0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 INITVAL_00 0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000
    // exemplar attribute lm32_monitor_ram_0_0_1 CSDECODE_B 000
    // exemplar attribute lm32_monitor_ram_0_0_1 CSDECODE_A 000
    // exemplar attribute lm32_monitor_ram_0_0_1 WRITEMODE_B NORMAL
    // exemplar attribute lm32_monitor_ram_0_0_1 WRITEMODE_A NORMAL
    // exemplar attribute lm32_monitor_ram_0_0_1 GSR DISABLED
    // exemplar attribute lm32_monitor_ram_0_0_1 RESETMODE SYNC
    // exemplar attribute lm32_monitor_ram_0_0_1 REGMODE_B NOREG
    // exemplar attribute lm32_monitor_ram_0_0_1 REGMODE_A NOREG
    // exemplar attribute lm32_monitor_ram_0_0_1 DATA_WIDTH_B 18
    // exemplar attribute lm32_monitor_ram_0_0_1 DATA_WIDTH_A 18
    // exemplar attribute lm32_monitor_ram_0_1_0 MEM_LPC_FILE lm32_monitor_ram.lpc
    // exemplar attribute lm32_monitor_ram_0_1_0 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_19 0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_18 0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_17 0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_16 0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_15 0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_14 0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_13 0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_12 0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_11 0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_10 0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0F 0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0E 0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0D 0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0C 0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0B 0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_0A 0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_09 0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_08 0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_07 0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_06 0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_05 0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_04 0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_03 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_02 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_01 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_0_1_0 INITVAL_00 0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600
    // exemplar attribute lm32_monitor_ram_0_1_0 CSDECODE_B 000
    // exemplar attribute lm32_monitor_ram_0_1_0 CSDECODE_A 000
    // exemplar attribute lm32_monitor_ram_0_1_0 WRITEMODE_B NORMAL
    // exemplar attribute lm32_monitor_ram_0_1_0 WRITEMODE_A NORMAL
    // exemplar attribute lm32_monitor_ram_0_1_0 GSR DISABLED
    // exemplar attribute lm32_monitor_ram_0_1_0 RESETMODE SYNC
    // exemplar attribute lm32_monitor_ram_0_1_0 REGMODE_B NOREG
    // exemplar attribute lm32_monitor_ram_0_1_0 REGMODE_A NOREG
    // exemplar attribute lm32_monitor_ram_0_1_0 DATA_WIDTH_B 18
    // exemplar attribute lm32_monitor_ram_0_1_0 DATA_WIDTH_A 18
    // exemplar end

      end else if (lat_family == "ECP2" || lat_family == "ECP2M" || lat_family == "XP2") begin 

/* Verilog netlist generated by SCUBA ispLever_v8.0_ALPHA (69) */
/* Module Version: 7.0 */
/* c:\ispTOOLS8_0\ispFPGA\bin\nt\scuba.exe -w -lang verilog -synth synplify -bus_exp 7 -bb -arch ep5a00 -type bram -wp 11 -rp 1010 -addr_width 9 -data_width 32 -num_rows 512 -gsr DISABLED -writemode NORMAL -resetmode SYNC -memfile ../../lm32_monitor.mem -memformat hex -e -n lm32_monitor_ram_ecp2  */
/* Tue Jun 16 18:01:57 2009 */

    // synopsys translate_off
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_3A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_39 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_38 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_37 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_36 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_35 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_34 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_33 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_32 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_31 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_30 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_2A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_29 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_28 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_27 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_26 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_25 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_24 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_23 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_22 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_21 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_20 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_19 = 320'h0000000000000000000000000000000000000000000000000000000000000000000000000003FF81 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_18 = 320'h300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_17 = 320'h3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_16 = 320'h068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_15 = 320'h3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_14 = 320'h00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_13 = 320'h070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_12 = 320'h200081000C0001030014200181001C00020300240000000000000001000000000000000000010000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_11 = 320'h100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_10 = 320'h30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0F = 320'h30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0E = 320'h1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0D = 320'h100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0C = 320'h0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0B = 320'h300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_0A = 320'h300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_09 = 320'h20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_08 = 320'h300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_07 = 320'h300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_06 = 320'h1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_05 = 320'h1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_04 = 320'h1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_03 = 320'h0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_02 = 320'h0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_01 = 320'h00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.INITVAL_00 = 320'h00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.CSDECODE_B =  3'b000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.CSDECODE_A =  3'b000 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.RESETMODE = "SYNC" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_ecp2_0_0_1.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_ecp2_0_0_1.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP16KB lm32_monitor_ram_ecp2_0_0_1 (.DIA0(DataInA[0]), .DIA1(DataInA[1]), 
        .DIA2(DataInA[2]), .DIA3(DataInA[3]), .DIA4(DataInA[4]), .DIA5(DataInA[5]), 
        .DIA6(DataInA[6]), .DIA7(DataInA[7]), .DIA8(DataInA[8]), .DIA9(DataInA[9]), 
        .DIA10(DataInA[10]), .DIA11(DataInA[11]), .DIA12(DataInA[12]), .DIA13(DataInA[13]), 
        .DIA14(DataInA[14]), .DIA15(DataInA[15]), .DIA16(DataInA[16]), .DIA17(DataInA[17]), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), 
        .WEA(WrA), .CSA0(scuba_vlo), .CSA1(scuba_vlo), .CSA2(scuba_vlo), 
        .RSTA(ResetA), .DIB0(DataInB[0]), .DIB1(DataInB[1]), .DIB2(DataInB[2]), 
        .DIB3(DataInB[3]), .DIB4(DataInB[4]), .DIB5(DataInB[5]), .DIB6(DataInB[6]), 
        .DIB7(DataInB[7]), .DIB8(DataInB[8]), .DIB9(DataInB[9]), .DIB10(DataInB[10]), 
        .DIB11(DataInB[11]), .DIB12(DataInB[12]), .DIB13(DataInB[13]), .DIB14(DataInB[14]), 
        .DIB15(DataInB[15]), .DIB16(DataInB[16]), .DIB17(DataInB[17]), .ADB0(scuba_vhi), 
        .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), .ADB4(AddressB[0]), 
        .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), .ADB8(AddressB[4]), 
        .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), .ADB12(AddressB[8]), 
        .ADB13(scuba_vlo), .CEB(ClockEnB), .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), 
        .CSB1(scuba_vlo), .CSB2(scuba_vlo), .RSTB(ResetB), .DOA0(QA[0]), 
        .DOA1(QA[1]), .DOA2(QA[2]), .DOA3(QA[3]), .DOA4(QA[4]), .DOA5(QA[5]), 
        .DOA6(QA[6]), .DOA7(QA[7]), .DOA8(QA[8]), .DOA9(QA[9]), .DOA10(QA[10]), 
        .DOA11(QA[11]), .DOA12(QA[12]), .DOA13(QA[13]), .DOA14(QA[14]), 
        .DOA15(QA[15]), .DOA16(QA[16]), .DOA17(QA[17]), .DOB0(QB[0]), .DOB1(QB[1]), 
        .DOB2(QB[2]), .DOB3(QB[3]), .DOB4(QB[4]), .DOB5(QB[5]), .DOB6(QB[6]), 
        .DOB7(QB[7]), .DOB8(QB[8]), .DOB9(QB[9]), .DOB10(QB[10]), .DOB11(QB[11]), 
        .DOB12(QB[12]), .DOB13(QB[13]), .DOB14(QB[14]), .DOB15(QB[15]), 
        .DOB16(QB[16]), .DOB17(QB[17]))
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram_ecp2.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81" */
             /* synthesis INITVAL_18="0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000" */
             /* synthesis INITVAL_17="0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000" */
             /* synthesis INITVAL_16="0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1" */
             /* synthesis INITVAL_15="0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012" */
             /* synthesis INITVAL_14="0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800" */
             /* synthesis INITVAL_13="0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004" */
             /* synthesis INITVAL_12="0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000" */
             /* synthesis INITVAL_11="0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000" */
             /* synthesis INITVAL_10="0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010" */
             /* synthesis INITVAL_0F="0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3" */
             /* synthesis INITVAL_0E="0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED" */
             /* synthesis INITVAL_0D="0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000" */
             /* synthesis INITVAL_0C="0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078" */
             /* synthesis INITVAL_0B="0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034" */
             /* synthesis INITVAL_0A="0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098" */
             /* synthesis INITVAL_09="0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054" */
             /* synthesis INITVAL_08="0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014" */
             /* synthesis INITVAL_07="0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF" */
             /* synthesis INITVAL_06="0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C" */
             /* synthesis INITVAL_05="0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C" */
             /* synthesis INITVAL_04="0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000" */
             /* synthesis INITVAL_03="0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000" */
             /* synthesis INITVAL_02="0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000" */
             /* synthesis INITVAL_01="0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000" */
             /* synthesis INITVAL_00="0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000" */
             /* synthesis CSDECODE_B="0b000" */
             /* synthesis CSDECODE_A="0b000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;

    VHI scuba_vhi_inst (.Z(scuba_vhi));

    VLO scuba_vlo_inst (.Z(scuba_vlo));

    // synopsys translate_off
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_3A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_39 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_38 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_37 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_36 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_35 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_34 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_33 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_32 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_31 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_30 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_2A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_29 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_28 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_27 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_26 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_25 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_24 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_23 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_22 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_21 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_20 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_19 = 320'h000000000000000000000000000000000000000000000000000000000000000000000000000038FF ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_18 = 320'h034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_17 = 320'h038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_16 = 320'h02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_15 = 320'h03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_14 = 320'h0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_13 = 320'h024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_12 = 320'h00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_11 = 320'h00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_10 = 320'h00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0F = 320'h016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0E = 320'h010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0D = 320'h016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0C = 320'h011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0B = 320'h00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_0A = 320'h00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_09 = 320'h0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_08 = 320'h00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_07 = 320'h00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_06 = 320'h00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_05 = 320'h016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_04 = 320'h016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_03 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_02 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_01 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.INITVAL_00 = 320'h0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.CSDECODE_B =  3'b000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.CSDECODE_A =  3'b000 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.WRITEMODE_B = "NORMAL" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.WRITEMODE_A = "NORMAL" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.GSR = "DISABLED" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.RESETMODE = "SYNC" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.REGMODE_B = "NOREG" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.REGMODE_A = "NOREG" ;
    defparam lm32_monitor_ram_ecp2_0_1_0.DATA_WIDTH_B = 18 ;
    defparam lm32_monitor_ram_ecp2_0_1_0.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP16KB lm32_monitor_ram_ecp2_0_1_0 (.DIA0(DataInA[18]), .DIA1(DataInA[19]), 
        .DIA2(DataInA[20]), .DIA3(DataInA[21]), .DIA4(DataInA[22]), .DIA5(DataInA[23]), 
        .DIA6(DataInA[24]), .DIA7(DataInA[25]), .DIA8(DataInA[26]), .DIA9(DataInA[27]), 
        .DIA10(DataInA[28]), .DIA11(DataInA[29]), .DIA12(DataInA[30]), .DIA13(DataInA[31]), 
        .DIA14(scuba_vlo), .DIA15(scuba_vlo), .DIA16(scuba_vlo), .DIA17(scuba_vlo), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), 
        .WEA(WrA), .CSA0(scuba_vlo), .CSA1(scuba_vlo), .CSA2(scuba_vlo), 
        .RSTA(ResetA), .DIB0(DataInB[18]), .DIB1(DataInB[19]), .DIB2(DataInB[20]), 
        .DIB3(DataInB[21]), .DIB4(DataInB[22]), .DIB5(DataInB[23]), .DIB6(DataInB[24]), 
        .DIB7(DataInB[25]), .DIB8(DataInB[26]), .DIB9(DataInB[27]), .DIB10(DataInB[28]), 
        .DIB11(DataInB[29]), .DIB12(DataInB[30]), .DIB13(DataInB[31]), .DIB14(scuba_vlo), 
        .DIB15(scuba_vlo), .DIB16(scuba_vlo), .DIB17(scuba_vlo), .ADB0(scuba_vhi), 
        .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), .ADB4(AddressB[0]), 
        .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), .ADB8(AddressB[4]), 
        .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), .ADB12(AddressB[8]), 
        .ADB13(scuba_vlo), .CEB(ClockEnB), .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), 
        .CSB1(scuba_vlo), .CSB2(scuba_vlo), .RSTB(ResetB), .DOA0(QA[18]), 
        .DOA1(QA[19]), .DOA2(QA[20]), .DOA3(QA[21]), .DOA4(QA[22]), .DOA5(QA[23]), 
        .DOA6(QA[24]), .DOA7(QA[25]), .DOA8(QA[26]), .DOA9(QA[27]), .DOA10(QA[28]), 
        .DOA11(QA[29]), .DOA12(QA[30]), .DOA13(QA[31]), .DOA14(), .DOA15(), 
        .DOA16(), .DOA17(), .DOB0(QB[18]), .DOB1(QB[19]), .DOB2(QB[20]), 
        .DOB3(QB[21]), .DOB4(QB[22]), .DOB5(QB[23]), .DOB6(QB[24]), .DOB7(QB[25]), 
        .DOB8(QB[26]), .DOB9(QB[27]), .DOB10(QB[28]), .DOB11(QB[29]), .DOB12(QB[30]), 
        .DOB13(QB[31]), .DOB14(), .DOB15(), .DOB16(), .DOB17())
             /* synthesis MEM_LPC_FILE="lm32_monitor_ram_ecp2.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF" */
             /* synthesis INITVAL_18="0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482" */
             /* synthesis INITVAL_17="0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03" */
             /* synthesis INITVAL_16="0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF" */
             /* synthesis INITVAL_15="0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10" */
             /* synthesis INITVAL_14="0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70" */
             /* synthesis INITVAL_13="0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7" */
             /* synthesis INITVAL_12="0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418" */
             /* synthesis INITVAL_11="0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84" */
             /* synthesis INITVAL_10="0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4" */
             /* synthesis INITVAL_0F="0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF" */
             /* synthesis INITVAL_0E="0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF" */
             /* synthesis INITVAL_0D="0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478" */
             /* synthesis INITVAL_0C="0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7" */
             /* synthesis INITVAL_0B="0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3" */
             /* synthesis INITVAL_0A="0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7" */
             /* synthesis INITVAL_09="0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5" */
             /* synthesis INITVAL_08="0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1" */
             /* synthesis INITVAL_07="0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808" */
             /* synthesis INITVAL_06="0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE" */
             /* synthesis INITVAL_05="0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA" */
             /* synthesis INITVAL_04="0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8" */
             /* synthesis INITVAL_03="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_02="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_01="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_00="0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600" */
             /* synthesis CSDECODE_B="0b000" */
             /* synthesis CSDECODE_A="0b000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;



    // exemplar begin
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 MEM_LPC_FILE lm32_monitor_ram_ecp2.lpc
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_3A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_39 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_38 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_37 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_36 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_35 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_34 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_33 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_32 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_31 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_30 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_2A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_29 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_28 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_27 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_26 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_25 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_24 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_23 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_22 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_21 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_20 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_19 0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_18 0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_17 0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_16 0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_15 0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_14 0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_13 0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_12 0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_11 0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_10 0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0F 0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0E 0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0D 0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0C 0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0B 0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_0A 0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_09 0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_08 0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_07 0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_06 0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_05 0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_04 0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_03 0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_02 0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_01 0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 INITVAL_00 0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 CSDECODE_B 0b000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 CSDECODE_A 0b000
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 WRITEMODE_B NORMAL
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 WRITEMODE_A NORMAL
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 GSR DISABLED
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 RESETMODE SYNC
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 REGMODE_B NOREG
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 REGMODE_A NOREG
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 DATA_WIDTH_B 18
    // exemplar attribute lm32_monitor_ram_ecp2_0_0_1 DATA_WIDTH_A 18
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 MEM_LPC_FILE lm32_monitor_ram_ecp2.lpc
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_3A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_39 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_38 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_37 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_36 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_35 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_34 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_33 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_32 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_31 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_30 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_2A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_29 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_28 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_27 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_26 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_25 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_24 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_23 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_22 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_21 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_20 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_19 0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_18 0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_17 0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_16 0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_15 0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_14 0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_13 0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_12 0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_11 0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_10 0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0F 0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0E 0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0D 0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0C 0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0B 0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_0A 0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_09 0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_08 0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_07 0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_06 0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_05 0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_04 0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_03 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_02 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_01 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 INITVAL_00 0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 CSDECODE_B 0b000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 CSDECODE_A 0b000
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 WRITEMODE_B NORMAL
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 WRITEMODE_A NORMAL
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 GSR DISABLED
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 RESETMODE SYNC
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 REGMODE_B NOREG
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 REGMODE_A NOREG
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 DATA_WIDTH_B 18
    // exemplar attribute lm32_monitor_ram_ecp2_0_1_0 DATA_WIDTH_A 18
    // exemplar end

      end   else if (lat_family == "SC" || lat_family == "SCM") begin 

/* Verilog netlist generated by SCUBA ispLever_v8.0_ALPHA (69) */
/* Module Version: 7.0 */
/* c:\ispTOOLS8_0\ispFPGA\bin\nt\scuba.exe -w -lang verilog -synth synplify -bus_exp 7 -bb -arch or5s00 -type bram -wp 11 -rp 1010 -addr_width 9 -data_width 32 -num_rows 512 -gsr DISABLED -sync_reset -memfile ../../lm32_monitor.mem -memformat hex -e -n sc_rom_monitor  */
/* Tue Jun 16 18:01:58 2009 */

    // synopsys translate_off
    defparam sc_rom_monitor_0_0_1.INITVAL_3F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_3E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_3D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_3C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_3B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_3A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_39 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_38 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_37 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_36 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_35 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_34 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_33 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_32 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_31 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_30 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_2A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_29 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_28 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_27 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_26 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_25 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_24 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_23 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_22 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_21 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_20 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_19 = 320'h0000000000000000000000000000000000000000000000000000000000000000000000000003FF81 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_18 = 320'h300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_17 = 320'h3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_16 = 320'h068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_15 = 320'h3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_14 = 320'h00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_13 = 320'h070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_12 = 320'h200081000C0001030014200181001C00020300240000000000000001000000000000000000010000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_11 = 320'h100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_10 = 320'h30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0F = 320'h30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0E = 320'h1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0D = 320'h100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0C = 320'h0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0B = 320'h300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_0A = 320'h300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_09 = 320'h20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_08 = 320'h300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_07 = 320'h300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF ;
    defparam sc_rom_monitor_0_0_1.INITVAL_06 = 320'h1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C ;
    defparam sc_rom_monitor_0_0_1.INITVAL_05 = 320'h1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C ;
    defparam sc_rom_monitor_0_0_1.INITVAL_04 = 320'h1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_03 = 320'h0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_02 = 320'h0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_01 = 320'h00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000 ;
    defparam sc_rom_monitor_0_0_1.INITVAL_00 = 320'h00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000 ;
    defparam sc_rom_monitor_0_0_1.CSDECODE_B =  3'b000 ;
    defparam sc_rom_monitor_0_0_1.CSDECODE_A =  3'b000 ;
    defparam sc_rom_monitor_0_0_1.WRITEMODE_B = "NORMAL" ;
    defparam sc_rom_monitor_0_0_1.WRITEMODE_A = "NORMAL" ;
    defparam sc_rom_monitor_0_0_1.GSR = "DISABLED" ;
    defparam sc_rom_monitor_0_0_1.RESETMODE = "SYNC" ;
    defparam sc_rom_monitor_0_0_1.REGMODE_B = "NOREG" ;
    defparam sc_rom_monitor_0_0_1.REGMODE_A = "NOREG" ;
    defparam sc_rom_monitor_0_0_1.DATA_WIDTH_B = 18 ;
    defparam sc_rom_monitor_0_0_1.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP16KA sc_rom_monitor_0_0_1 (.DIA0(DataInA[0]), .DIA1(DataInA[1]), .DIA2(DataInA[2]), 
        .DIA3(DataInA[3]), .DIA4(DataInA[4]), .DIA5(DataInA[5]), .DIA6(DataInA[6]), 
        .DIA7(DataInA[7]), .DIA8(DataInA[8]), .DIA9(DataInA[9]), .DIA10(DataInA[10]), 
        .DIA11(DataInA[11]), .DIA12(DataInA[12]), .DIA13(DataInA[13]), .DIA14(DataInA[14]), 
        .DIA15(DataInA[15]), .DIA16(DataInA[16]), .DIA17(DataInA[17]), .ADA0(scuba_vhi), 
        .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), .ADA4(AddressA[0]), 
        .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), .ADA8(AddressA[4]), 
        .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), .ADA12(AddressA[8]), 
        .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), .WEA(WrA), .CSA0(scuba_vlo), 
        .CSA1(scuba_vlo), .CSA2(scuba_vlo), .RSTA(ResetA), .DIB0(DataInB[0]), 
        .DIB1(DataInB[1]), .DIB2(DataInB[2]), .DIB3(DataInB[3]), .DIB4(DataInB[4]), 
        .DIB5(DataInB[5]), .DIB6(DataInB[6]), .DIB7(DataInB[7]), .DIB8(DataInB[8]), 
        .DIB9(DataInB[9]), .DIB10(DataInB[10]), .DIB11(DataInB[11]), .DIB12(DataInB[12]), 
        .DIB13(DataInB[13]), .DIB14(DataInB[14]), .DIB15(DataInB[15]), .DIB16(DataInB[16]), 
        .DIB17(DataInB[17]), .ADB0(scuba_vhi), .ADB1(scuba_vhi), .ADB2(scuba_vlo), 
        .ADB3(scuba_vlo), .ADB4(AddressB[0]), .ADB5(AddressB[1]), .ADB6(AddressB[2]), 
        .ADB7(AddressB[3]), .ADB8(AddressB[4]), .ADB9(AddressB[5]), .ADB10(AddressB[6]), 
        .ADB11(AddressB[7]), .ADB12(AddressB[8]), .ADB13(scuba_vlo), .CEB(ClockEnB), 
        .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), .CSB1(scuba_vlo), .CSB2(scuba_vlo), 
        .RSTB(ResetB), .DOA0(QA[0]), .DOA1(QA[1]), .DOA2(QA[2]), .DOA3(QA[3]), 
        .DOA4(QA[4]), .DOA5(QA[5]), .DOA6(QA[6]), .DOA7(QA[7]), .DOA8(QA[8]), 
        .DOA9(QA[9]), .DOA10(QA[10]), .DOA11(QA[11]), .DOA12(QA[12]), .DOA13(QA[13]), 
        .DOA14(QA[14]), .DOA15(QA[15]), .DOA16(QA[16]), .DOA17(QA[17]), 
        .DOB0(QB[0]), .DOB1(QB[1]), .DOB2(QB[2]), .DOB3(QB[3]), .DOB4(QB[4]), 
        .DOB5(QB[5]), .DOB6(QB[6]), .DOB7(QB[7]), .DOB8(QB[8]), .DOB9(QB[9]), 
        .DOB10(QB[10]), .DOB11(QB[11]), .DOB12(QB[12]), .DOB13(QB[13]), 
        .DOB14(QB[14]), .DOB15(QB[15]), .DOB16(QB[16]), .DOB17(QB[17]))
             /* synthesis MEM_LPC_FILE="sc_rom_monitor.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81" */
             /* synthesis INITVAL_18="0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000" */
             /* synthesis INITVAL_17="0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000" */
             /* synthesis INITVAL_16="0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1" */
             /* synthesis INITVAL_15="0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012" */
             /* synthesis INITVAL_14="0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800" */
             /* synthesis INITVAL_13="0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004" */
             /* synthesis INITVAL_12="0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000" */
             /* synthesis INITVAL_11="0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000" */
             /* synthesis INITVAL_10="0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010" */
             /* synthesis INITVAL_0F="0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3" */
             /* synthesis INITVAL_0E="0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED" */
             /* synthesis INITVAL_0D="0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000" */
             /* synthesis INITVAL_0C="0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078" */
             /* synthesis INITVAL_0B="0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034" */
             /* synthesis INITVAL_0A="0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098" */
             /* synthesis INITVAL_09="0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054" */
             /* synthesis INITVAL_08="0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014" */
             /* synthesis INITVAL_07="0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF" */
             /* synthesis INITVAL_06="0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C" */
             /* synthesis INITVAL_05="0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C" */
             /* synthesis INITVAL_04="0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000" */
             /* synthesis INITVAL_03="0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000" */
             /* synthesis INITVAL_02="0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000" */
             /* synthesis INITVAL_01="0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000" */
             /* synthesis INITVAL_00="0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000" */
             /* synthesis CSDECODE_B="0b000" */
             /* synthesis CSDECODE_A="0b000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;

    VHI scuba_vhi_inst (.Z(scuba_vhi));

    VLO scuba_vlo_inst (.Z(scuba_vlo));

    // synopsys translate_off
    defparam sc_rom_monitor_0_1_0.INITVAL_3F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_3E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_3D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_3C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_3B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_3A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_39 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_38 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_37 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_36 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_35 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_34 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_33 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_32 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_31 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_30 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_2A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_29 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_28 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_27 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_26 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_25 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_24 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_23 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_22 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_21 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_20 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_19 = 320'h000000000000000000000000000000000000000000000000000000000000000000000000000038FF ;
    defparam sc_rom_monitor_0_1_0.INITVAL_18 = 320'h034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_17 = 320'h038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_16 = 320'h02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF ;
    defparam sc_rom_monitor_0_1_0.INITVAL_15 = 320'h03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_14 = 320'h0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_13 = 320'h024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_12 = 320'h00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_11 = 320'h00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_10 = 320'h00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0F = 320'h016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0E = 320'h010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0D = 320'h016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0C = 320'h011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0B = 320'h00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_0A = 320'h00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_09 = 320'h0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_08 = 320'h00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_07 = 320'h00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_06 = 320'h00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE ;
    defparam sc_rom_monitor_0_1_0.INITVAL_05 = 320'h016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA ;
    defparam sc_rom_monitor_0_1_0.INITVAL_04 = 320'h016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_03 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_02 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_01 = 320'h0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600 ;
    defparam sc_rom_monitor_0_1_0.INITVAL_00 = 320'h0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600 ;
    defparam sc_rom_monitor_0_1_0.CSDECODE_B =  3'b000 ;
    defparam sc_rom_monitor_0_1_0.CSDECODE_A =  3'b000 ;
    defparam sc_rom_monitor_0_1_0.WRITEMODE_B = "NORMAL" ;
    defparam sc_rom_monitor_0_1_0.WRITEMODE_A = "NORMAL" ;
    defparam sc_rom_monitor_0_1_0.GSR = "DISABLED" ;
    defparam sc_rom_monitor_0_1_0.RESETMODE = "SYNC" ;
    defparam sc_rom_monitor_0_1_0.REGMODE_B = "NOREG" ;
    defparam sc_rom_monitor_0_1_0.REGMODE_A = "NOREG" ;
    defparam sc_rom_monitor_0_1_0.DATA_WIDTH_B = 18 ;
    defparam sc_rom_monitor_0_1_0.DATA_WIDTH_A = 18 ;
    // synopsys translate_on
    DP16KA sc_rom_monitor_0_1_0 (.DIA0(DataInA[18]), .DIA1(DataInA[19]), 
        .DIA2(DataInA[20]), .DIA3(DataInA[21]), .DIA4(DataInA[22]), .DIA5(DataInA[23]), 
        .DIA6(DataInA[24]), .DIA7(DataInA[25]), .DIA8(DataInA[26]), .DIA9(DataInA[27]), 
        .DIA10(DataInA[28]), .DIA11(DataInA[29]), .DIA12(DataInA[30]), .DIA13(DataInA[31]), 
        .DIA14(scuba_vlo), .DIA15(scuba_vlo), .DIA16(scuba_vlo), .DIA17(scuba_vlo), 
        .ADA0(scuba_vhi), .ADA1(scuba_vhi), .ADA2(scuba_vlo), .ADA3(scuba_vlo), 
        .ADA4(AddressA[0]), .ADA5(AddressA[1]), .ADA6(AddressA[2]), .ADA7(AddressA[3]), 
        .ADA8(AddressA[4]), .ADA9(AddressA[5]), .ADA10(AddressA[6]), .ADA11(AddressA[7]), 
        .ADA12(AddressA[8]), .ADA13(scuba_vlo), .CEA(ClockEnA), .CLKA(ClockA), 
        .WEA(WrA), .CSA0(scuba_vlo), .CSA1(scuba_vlo), .CSA2(scuba_vlo), 
        .RSTA(ResetA), .DIB0(DataInB[18]), .DIB1(DataInB[19]), .DIB2(DataInB[20]), 
        .DIB3(DataInB[21]), .DIB4(DataInB[22]), .DIB5(DataInB[23]), .DIB6(DataInB[24]), 
        .DIB7(DataInB[25]), .DIB8(DataInB[26]), .DIB9(DataInB[27]), .DIB10(DataInB[28]), 
        .DIB11(DataInB[29]), .DIB12(DataInB[30]), .DIB13(DataInB[31]), .DIB14(scuba_vlo), 
        .DIB15(scuba_vlo), .DIB16(scuba_vlo), .DIB17(scuba_vlo), .ADB0(scuba_vhi), 
        .ADB1(scuba_vhi), .ADB2(scuba_vlo), .ADB3(scuba_vlo), .ADB4(AddressB[0]), 
        .ADB5(AddressB[1]), .ADB6(AddressB[2]), .ADB7(AddressB[3]), .ADB8(AddressB[4]), 
        .ADB9(AddressB[5]), .ADB10(AddressB[6]), .ADB11(AddressB[7]), .ADB12(AddressB[8]), 
        .ADB13(scuba_vlo), .CEB(ClockEnB), .CLKB(ClockB), .WEB(WrB), .CSB0(scuba_vlo), 
        .CSB1(scuba_vlo), .CSB2(scuba_vlo), .RSTB(ResetB), .DOA0(QA[18]), 
        .DOA1(QA[19]), .DOA2(QA[20]), .DOA3(QA[21]), .DOA4(QA[22]), .DOA5(QA[23]), 
        .DOA6(QA[24]), .DOA7(QA[25]), .DOA8(QA[26]), .DOA9(QA[27]), .DOA10(QA[28]), 
        .DOA11(QA[29]), .DOA12(QA[30]), .DOA13(QA[31]), .DOA14(), .DOA15(), 
        .DOA16(), .DOA17(), .DOB0(QB[18]), .DOB1(QB[19]), .DOB2(QB[20]), 
        .DOB3(QB[21]), .DOB4(QB[22]), .DOB5(QB[23]), .DOB6(QB[24]), .DOB7(QB[25]), 
        .DOB8(QB[26]), .DOB9(QB[27]), .DOB10(QB[28]), .DOB11(QB[29]), .DOB12(QB[30]), 
        .DOB13(QB[31]), .DOB14(), .DOB15(), .DOB16(), .DOB17())
             /* synthesis MEM_LPC_FILE="sc_rom_monitor.lpc" */
             /* synthesis MEM_INIT_FILE="lm32_monitor.mem" */
             /* synthesis INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000" */
             /* synthesis INITVAL_19="0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF" */
             /* synthesis INITVAL_18="0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482" */
             /* synthesis INITVAL_17="0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03" */
             /* synthesis INITVAL_16="0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF" */
             /* synthesis INITVAL_15="0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10" */
             /* synthesis INITVAL_14="0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70" */
             /* synthesis INITVAL_13="0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7" */
             /* synthesis INITVAL_12="0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418" */
             /* synthesis INITVAL_11="0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84" */
             /* synthesis INITVAL_10="0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4" */
             /* synthesis INITVAL_0F="0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF" */
             /* synthesis INITVAL_0E="0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF" */
             /* synthesis INITVAL_0D="0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478" */
             /* synthesis INITVAL_0C="0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7" */
             /* synthesis INITVAL_0B="0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3" */
             /* synthesis INITVAL_0A="0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7" */
             /* synthesis INITVAL_09="0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5" */
             /* synthesis INITVAL_08="0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1" */
             /* synthesis INITVAL_07="0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808" */
             /* synthesis INITVAL_06="0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE" */
             /* synthesis INITVAL_05="0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA" */
             /* synthesis INITVAL_04="0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8" */
             /* synthesis INITVAL_03="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_02="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_01="0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600" */
             /* synthesis INITVAL_00="0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600" */
             /* synthesis CSDECODE_B="0b000" */
             /* synthesis CSDECODE_A="0b000" */
             /* synthesis WRITEMODE_B="NORMAL" */
             /* synthesis WRITEMODE_A="NORMAL" */
             /* synthesis GSR="DISABLED" */
             /* synthesis RESETMODE="SYNC" */
             /* synthesis REGMODE_B="NOREG" */
             /* synthesis REGMODE_A="NOREG" */
             /* synthesis DATA_WIDTH_B="18" */
             /* synthesis DATA_WIDTH_A="18" */;



    // exemplar begin
    // exemplar attribute sc_rom_monitor_0_0_1 MEM_LPC_FILE sc_rom_monitor.lpc
    // exemplar attribute sc_rom_monitor_0_0_1 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_3A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_39 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_38 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_37 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_36 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_35 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_34 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_33 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_32 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_31 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_30 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_2A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_29 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_28 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_27 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_26 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_25 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_24 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_23 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_22 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_21 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_20 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_19 0x0000000000000000000000000000000000000000000000000000000000000000000000000003FF81
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_18 0x300003FF83300003FF85300003FF873FF4A1004F3FF8A300003FF8C300003FF8E300003FF9030000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_17 0x3FF92300003FF94300003FF96300003FFC100800070003FFFB0000130001100003FF5B1001700000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_16 0x068003FF70058003FF723FFFB300013FF6A00001100001FFAB00000068003FF7B058003FF7D3FFB1
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_15 0x3FF8D008003FFB4300000FFB61001B000361001A0002F10019000381001800038100130003310012
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_14 0x00033100110003310010000331000900033100080003310007010003FF89058003FF9C3FFF900800
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_13 0x070000FFFB30800070003FFD63FFB200800000041000A0004110006010003FF9A000000002410004
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_12 0x200081000C0001030014200181001C00020300240000000000000001000000000000000000010000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_11 0x100010FFF310063000501004D000471006D00046100720002C100570001F10077010003FFBC00000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_10 0x30000044003FC0010000100540FFFF0080010000100540FFFF008000880010004200081000C00010
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0F 0x30014200181001C00020300240FFDC0000000008100043FFDD100083FFDF100093FFE11000A3FFE3
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0E 0x1000B10008100040FFF8000000000C1000410008100083FFE7100093FFE91000A3FFEB1000B3FFED
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0D 0x100040FFF400000200000FFFF01000000000000210054100000FFFF01000100FF00000100FF00000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0C 0x0FFFE1010001000000000007430084200002009830000300943000030090300003008C2007C10078
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0B 0x300702006C1006800064300602005C1005800054300502004C1004800044300402003C1003800034
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_0A 0x300302002C1002800024300202001C1001800014300102000C100080000000074200842000020098
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_09 0x20000200942000020090200002008C3008010078300702006C1006800064300602005C1005800054
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_08 0x300502004C1004800044300402003C1003800034300302002C1002800024300202001C1001800014
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_07 0x300102000C10008000001F9A00E000000041007810000100881000110001100011000110001100FF
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_06 0x1F9A0100940080010090008001008C008001009C008001009800800300802007C00074300702006C
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_05 0x1006800064300602005C1005800054300502004C1004800044300402003C1003800034300302002C
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_04 0x1002800024300202001C1001800014300102000C100080000000000106603FFC530000007F40E000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_03 0x0003E000BC1000400800200840000A000000000000046000C4100040080020084000120000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_02 0x0004E000CC1000400800200840001A000000000000056000D4100040080020084000220000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_01 0x00086000DC1000400800300840002A000000000000066000E4100040080020084000320000000000
    // exemplar attribute sc_rom_monitor_0_0_1 INITVAL_00 0x00096000EC1000400800300840003A000000000000000000000000000000000000003E0000000000
    // exemplar attribute sc_rom_monitor_0_0_1 CSDECODE_B 0b000
    // exemplar attribute sc_rom_monitor_0_0_1 CSDECODE_A 0b000
    // exemplar attribute sc_rom_monitor_0_0_1 WRITEMODE_B NORMAL
    // exemplar attribute sc_rom_monitor_0_0_1 WRITEMODE_A NORMAL
    // exemplar attribute sc_rom_monitor_0_0_1 GSR DISABLED
    // exemplar attribute sc_rom_monitor_0_0_1 RESETMODE SYNC
    // exemplar attribute sc_rom_monitor_0_0_1 REGMODE_B NOREG
    // exemplar attribute sc_rom_monitor_0_0_1 REGMODE_A NOREG
    // exemplar attribute sc_rom_monitor_0_0_1 DATA_WIDTH_B 18
    // exemplar attribute sc_rom_monitor_0_0_1 DATA_WIDTH_A 18
    // exemplar attribute sc_rom_monitor_0_1_0 MEM_LPC_FILE sc_rom_monitor.lpc
    // exemplar attribute sc_rom_monitor_0_1_0 MEM_INIT_FILE lm32_monitor.mem
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_3A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_39 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_38 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_37 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_36 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_35 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_34 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_33 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_32 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_31 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_30 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_2A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_29 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_28 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_27 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_26 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_25 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_24 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_23 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_22 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_21 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_20 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1F 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1E 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1D 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1C 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1B 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_1A 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_19 0x000000000000000000000000000000000000000000000000000000000000000000000000000038FF
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_18 0x034D2038FF034C2038FF0349A038FF03EFF00D00038FF034CA038FF03492038FF0348A038FF03482
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_17 0x038FF0344A038FF03442038FF0343A038FF02E7002430038FF00D6300D5A00C5803EFF0136300D03
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_16 0x02E0803EFF02E0803EFF038FF00D5A03EFF00D63010580136300D0302E0803EFF02E0803EFF038FF
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_15 0x03EFF02E88038FF034DA0170801F100110801F100110801F100110801F100110801F100110801F10
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_14 0x0110801F100110801F100110801F100110801F100110801F0802E0803EFF02E0803EFF038FF02E70
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_13 0x024500110C0287302430038FF03EFF02E700110801F100110801F0802E0803EFF030E800DE700AE7
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_12 0x00AE400AE400AE400AE300AE300AE300AE300AE200D0000D0000D000342000D0000D0000D0003418
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_11 0x00D000170801F100110801F100110801F100110801F100110801F100110801F0802E0803EFF00E84
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_10 0x00E7B01E0401E030347000D0001708024700347000D00017080247002E08016E7016E4016E4016E4
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0F 0x016E3016E3016E3016E3016E200DE7030E800DE700AE703EFF010E003EFF010E003EFF010E003EFF
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0E 0x010E0016E0016E700DE7030E800DE700AE700AE000CE003EFF00CE003EFF00CE003EFF00CE003EFF
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0D 0x016E700DE7030E8034700171002470030E80110801F0803470017100247000808030E80081003478
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0C 0x011080081002478030F800AE700AE70340F00AE70340700AE70344F00AE70343F00AE700AE700AE7
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0B 0x00AE600AE600AE600AE600AE500AE500AE500AE500AE400AE400AE400AE400AE300AE300AE300AE3
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_0A 0x00AE200AE200AE200AE200AE100AE100AE100AE100AE000AE000AE0030F000AE700AE70340F00AE7
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_09 0x0340700AE70344F00AE70343F00AE700AE700AE700AE600AE600AE600AE600AE500AE500AE500AE5
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_08 0x00AE400AE400AE400AE400AE300AE300AE300AE300AE200AE200AE200AE200AE100AE100AE100AE1
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_07 0x00AE000AE000AE0030E800DEF02EE8016E8016E800AE8016E8000080000800008000080000800808
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_06 0x00DE8016E802400016E802448016E802438016E802410016E802408016EF016EF016EF016EE016EE
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_05 0x016EE016EE016ED016ED016ED016ED016EC016EC016EC016EC016EB016EB016EB016EB016EA016EA
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_04 0x016EA016EA016E9016E9016E9016E9016E8016E8016E802600016E800DEF038FF00D0700DE702EE8
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_03 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_02 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_01 0x0380003E0000D0802EE0016E703E0002EE8026000380003E0000D0802EE0016E703E0002EE802600
    // exemplar attribute sc_rom_monitor_0_1_0 INITVAL_00 0x0380003E0000D0802EE0016E703E0002EE80260000D0000D0000D0000D0000D0003E000340802600
    // exemplar attribute sc_rom_monitor_0_1_0 CSDECODE_B 0b000
    // exemplar attribute sc_rom_monitor_0_1_0 CSDECODE_A 0b000
    // exemplar attribute sc_rom_monitor_0_1_0 WRITEMODE_B NORMAL
    // exemplar attribute sc_rom_monitor_0_1_0 WRITEMODE_A NORMAL
    // exemplar attribute sc_rom_monitor_0_1_0 GSR DISABLED
    // exemplar attribute sc_rom_monitor_0_1_0 RESETMODE SYNC
    // exemplar attribute sc_rom_monitor_0_1_0 REGMODE_B NOREG
    // exemplar attribute sc_rom_monitor_0_1_0 REGMODE_A NOREG
    // exemplar attribute sc_rom_monitor_0_1_0 DATA_WIDTH_B 18
    // exemplar attribute sc_rom_monitor_0_1_0 DATA_WIDTH_A 18
    // exemplar end


      end
   endgenerate
   
endmodule

